package com.soss.system.service;

import java.util.List;
import com.soss.system.domain.ShopGoodsSku;

/**
 * 从店铺到sku关联Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IShopGoodsSkuService 
{
    /**
     * 查询从店铺到sku关联
     * 
     * @param id 从店铺到sku关联主键
     * @return 从店铺到sku关联
     */
    public ShopGoodsSku selectShopGoodsSkuById(String id);

    /**
     * 查询从店铺到sku关联列表
     * 
     * @param shopGoodsSku 从店铺到sku关联
     * @return 从店铺到sku关联集合
     */
    public List<ShopGoodsSku> selectShopGoodsSkuList(ShopGoodsSku shopGoodsSku);

    /**
     * 新增从店铺到sku关联
     * 
     * @param shopGoodsSku 从店铺到sku关联
     * @return 结果
     */
    public int insertShopGoodsSku(ShopGoodsSku shopGoodsSku);

    /**
     * 修改从店铺到sku关联
     * 
     * @param shopGoodsSku 从店铺到sku关联
     * @return 结果
     */
    public int updateShopGoodsSku(ShopGoodsSku shopGoodsSku);

    /**
     * 批量删除从店铺到sku关联
     * 
     * @param ids 需要删除的从店铺到sku关联主键集合
     * @return 结果
     */
    public int deleteShopGoodsSkuByIds(String[] ids);

    /**
     * 删除从店铺到sku关联信息
     * 
     * @param id 从店铺到sku关联主键
     * @return 结果
     */
    public int deleteShopGoodsSkuById(String id);
}
