package com.soss.system.service;

import java.util.List;

import com.soss.system.domain.Goods;
import com.soss.system.domain.ShopRecommend;

/**
 * 推荐和今日特惠Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IShopRecommendService 
{
    /**
     * 查询推荐和今日特惠
     * 
     * @param id 推荐和今日特惠主键
     * @return 推荐和今日特惠
     */
    public ShopRecommend selectShopRecommendById(String id);

    /**
     * 查询推荐和今日特惠列表
     * 
     * @param shopRecommend 推荐和今日特惠
     * @return 推荐和今日特惠集合
     */
    public List<Goods> selectShopRecommendList(ShopRecommend shopRecommend);

    /**
     * 新增推荐和今日特惠
     * 
     * @param shopRecommend 推荐和今日特惠
     * @return 结果
     */
    public int insertShopRecommend(ShopRecommend shopRecommend);

    /**
     * 修改推荐和今日特惠
     * 
     * @param shopRecommend 推荐和今日特惠
     * @return 结果
     */
    public int updateShopRecommend(ShopRecommend shopRecommend);

    /**
     * 批量删除推荐和今日特惠
     * 
     * @param ids 需要删除的推荐和今日特惠主键集合
     * @return 结果
     */
    public int deleteShopRecommendByIds(String[] ids);

    /**
     * 删除推荐和今日特惠信息
     * 
     * @param id 推荐和今日特惠主键
     * @return 结果
     */
    public int deleteShopRecommendById(String id);

    String turn(Long shopId, String fistId, String lastId, String type);

    int deleteShopRecommend(String goodsId, String shopId, String type);
}
