package com.soss.system.service;

import java.util.List;
import com.soss.system.domain.SpecRuleMaterial;

/**
 * 选项原料关联Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface ISpecRuleMaterialService 
{
    /**
     * 查询选项原料关联
     * 
     * @param id 选项原料关联主键
     * @return 选项原料关联
     */
    public SpecRuleMaterial selectSpecRuleMaterialById(String id);

    /**
     * 查询选项原料关联列表
     * 
     * @param specRuleMaterial 选项原料关联
     * @return 选项原料关联集合
     */
    public List<SpecRuleMaterial> selectSpecRuleMaterialList(SpecRuleMaterial specRuleMaterial);

    /**
     * 新增选项原料关联
     * 
     * @param specRuleMaterial 选项原料关联
     * @return 结果
     */
    public int insertSpecRuleMaterial(SpecRuleMaterial specRuleMaterial);

    /**
     * 修改选项原料关联
     * 
     * @param specRuleMaterial 选项原料关联
     * @return 结果
     */
    public int updateSpecRuleMaterial(SpecRuleMaterial specRuleMaterial);

    /**
     * 批量删除选项原料关联
     * 
     * @param ids 需要删除的选项原料关联主键集合
     * @return 结果
     */
    public int deleteSpecRuleMaterialByIds(String[] ids);

    /**
     * 删除选项原料关联信息
     * 
     * @param id 选项原料关联主键
     * @return 结果
     */
    public int deleteSpecRuleMaterialById(String id);
}
