package com.soss.system.service;

import java.util.List;
import com.soss.system.domain.Spec;

/**
 * 规格Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface ISpecService 
{
    /**
     * 查询规格
     * 
     * @param id 规格主键
     * @return 规格
     */
    public Spec selectSpecById(String id);

    /**
     * 查询规格列表
     * 
     * @param spec 规格
     * @return 规格集合
     */
    public List<Spec> selectSpecList(Spec spec);

    /**
     * 新增规格
     * 
     * @param spec 规格
     * @return 结果
     */
    public int insertSpec(Spec spec);

    /**
     * 修改规格
     * 
     * @param spec 规格
     * @return 结果
     */
    public int updateSpec(Spec spec);

    /**
     * 批量删除规格
     * 
     * @param ids 需要删除的规格主键集合
     * @return 结果
     */
    public int deleteSpecByIds(String[] ids);

    /**
     * 删除规格信息
     * 
     * @param id 规格主键
     * @return 结果
     */
    public int deleteSpecById(String id);
}
