package com.soss.system.service;

import java.util.List;
import com.soss.system.domain.WechatUser;

/**
 * 微信用户小程序信息（用于发送消息）Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IWechatUserService 
{
    /**
     * 查询微信用户小程序信息（用于发送消息）
     * 
     * @param id 微信用户小程序信息（用于发送消息）主键
     * @return 微信用户小程序信息（用于发送消息）
     */
    public WechatUser selectWechatUserById(String id);

    /**
     * 查询微信用户小程序信息（用于发送消息）列表
     * 
     * @param wechatUser 微信用户小程序信息（用于发送消息）
     * @return 微信用户小程序信息（用于发送消息）集合
     */
    public List<WechatUser> selectWechatUserList(WechatUser wechatUser);

    /**
     * 新增微信用户小程序信息（用于发送消息）
     * 
     * @param wechatUser 微信用户小程序信息（用于发送消息）
     * @return 结果
     */
    public int insertWechatUser(WechatUser wechatUser);

    /**
     * 修改微信用户小程序信息（用于发送消息）
     * 
     * @param wechatUser 微信用户小程序信息（用于发送消息）
     * @return 结果
     */
    public int updateWechatUser(WechatUser wechatUser);

    /**
     * 批量删除微信用户小程序信息（用于发送消息）
     * 
     * @param ids 需要删除的微信用户小程序信息（用于发送消息）主键集合
     * @return 结果
     */
    public int deleteWechatUserByIds(String[] ids);

    /**
     * 删除微信用户小程序信息（用于发送消息）信息
     * 
     * @param id 微信用户小程序信息（用于发送消息）主键
     * @return 结果
     */
    public int deleteWechatUserById(String id);
}
