package com.soss.system.service.impl;

import com.soss.common.utils.StringUtils;
import com.soss.system.domain.Shop;
import com.soss.system.mapper.ShopMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.util.List;

@Service
public class AppServiceImpl {
    @Autowired
    private ShopMapper shopMapper;
    public Shop getShop(String lng, String lat) {
            Shop shop = new Shop();
            shop.setState("1");
            shop.setIsDefault(1L);
            List<Shop> shops = shopMapper.selectShopList(shop);
            if(shops !=null &&!shops.isEmpty()){
                Shop shop1 = shops.get(0);
                shop1.setDistance("-1");
                if(StringUtils.isNotEmpty(lng)&&StringUtils.isNotEmpty(lat)){
                    //List<Shop> shopList = shopMapper.selectShopList(new Shop());

                    shop1.setDistance(AppServiceImpl.GetDistance(Double.parseDouble(lng),Double.parseDouble(lat),Double.parseDouble(shop1.getLng()),Double.parseDouble(shop1.getLat())));
                }
                return shop1;
            }else{
                return new Shop();
            }


    }

    private static final double EARTH_RADIUS = 6378137;
    /**
     * 根据两点间经纬度坐标（double值），计算两点间距离，单位为米
     * @param lng1
     * @param lat1
     * @param lng2
     * @param lat2
     * @return
     */
    public static String GetDistance(double lng1, double lat1, double lng2, double lat2)
    {
        double radLat1 = rad(lat1);
        double radLat2 = rad(lat2);
        double a = radLat1 - radLat2;
        double b = rad(lng1) - rad(lng2);
        double s = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(a/2),2) +
                Math.cos(radLat1)*Math.cos(radLat2)*Math.pow(Math.sin(b/2),2)));
        s = s * EARTH_RADIUS;
        s = Math.round(s * 10000) / 10000;
        String distance = null;
        if(s>1000&&s<10000){
            DecimalFormat df = new DecimalFormat("######0.0");
            distance = df.format(s/1000);
            return distance+"公里";

        }else if (s>=10000){
            Double aDouble = s/10000;

            return aDouble.intValue()+"公里";
        }else{
            Double aDouble =s;

            return aDouble.intValue()+"米";
        }
    }

    private static double rad(double d)
    {
        return d * Math.PI / 180.0;
    }

}
