package com.soss.system.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.soss.common.utils.DateUtils;
import com.soss.system.constants.OrderStatusConstant;
import com.soss.system.domain.Order;
import com.soss.system.domain.vo.customer.CustomerQueryVo;
import com.soss.system.domain.vo.customer.CustomerResultVo;
import com.soss.system.mapper.OrderMapper;
import com.soss.system.mapper.ShopMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.CustomerMapper;
import com.soss.system.domain.Customer;
import com.soss.system.service.ICustomerService;

/**
 * 用户信息Service业务层处理
 * 
 * @author zxq
 * @date 2022-05-01
 */
@Service
public class CustomerServiceImpl implements ICustomerService 
{
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ShopMapper shopMapper;

    /**
     * 查询用户信息
     * 
     * @param id 用户信息主键
     * @param status
     * @return 用户信息
     */
    @Override
    public List<Order> selectCustomerById(String id, String status)
    {
        Order order = new Order();
        order.setUserId(id);
        List<String> normalStatus = Arrays.asList(OrderStatusConstant.PaidCancel,OrderStatusConstant.Unpaid,OrderStatusConstant.Paid,OrderStatusConstant.production,OrderStatusConstant.productionCompleted,OrderStatusConstant.Taking,OrderStatusConstant.completed);
        List<String> cancelStatus = Arrays.asList(OrderStatusConstant.PaidCancel,OrderStatusConstant.UnpaidCancel,OrderStatusConstant.productionCancel,OrderStatusConstant.productionCompletedCancel);
        List<String> refundStatus = Arrays.asList(OrderStatusConstant.refunding,OrderStatusConstant.refundFailed,OrderStatusConstant.PartialRefund,OrderStatusConstant.refund);
        List<Order> orders = null;
        if("1".equals(status)){
            orders = orderMapper.selectOrderByUserId(id,normalStatus);
        }else if("2".equals(status)){
            orders = orderMapper.selectOrderByUserId(id,cancelStatus);
        }else{
            orders = orderMapper.selectOrderByUserId(id,refundStatus);
        }
        for (Order order1 : orders) {
            order1.setShop(shopMapper.selectShopById(order1.getShopId()));
        }
        return orders;



    }

    /**
     * 查询用户信息列表
     * 
     * @param customer 用户信息
     * @return 用户信息
     */
    @Override
    public List<CustomerResultVo> selectCustomerList(CustomerQueryVo customer)
    {

        List<CustomerResultVo> customerResultVos = customerMapper.selectCustomerByQuery(customer);
        return customerResultVos;
    }

    /**
     * 新增用户信息
     * 
     * @param customer 用户信息
     * @return 结果
     */
    @Override
    public int insertCustomer(Customer customer)
    {
        customer.setCreateTime(DateUtils.getNowDate());
        return customerMapper.insertCustomer(customer);
    }

    /**
     * 修改用户信息
     * 
     * @param customer 用户信息
     * @return 结果
     */
    @Override
    public int updateCustomer(Customer customer)
    {
        return customerMapper.updateCustomer(customer);
    }

    /**
     * 批量删除用户信息
     * 
     * @param ids 需要删除的用户信息主键
     * @return 结果
     */
    @Override
    public int deleteCustomerByIds(Long[] ids)
    {
        return customerMapper.deleteCustomerByIds(ids);
    }

    /**
     * 删除用户信息信息
     * 
     * @param id 用户信息主键
     * @return 结果
     */
    @Override
    public int deleteCustomerById(Long id)
    {
        return customerMapper.deleteCustomerById(id);
    }

    @Override
    public Integer allow(String openId, String allow) {
        Customer customer = new Customer();
        customer.setId(openId);
        customer.setAllow("1");
        return customerMapper.updateCustomer(customer);
    }
}
