package com.soss.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.GoodsTagMapper;
import com.soss.system.domain.GoodsTag;
import com.soss.system.service.IGoodsTagService;

/**
 * 商品标签Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class GoodsTagServiceImpl implements IGoodsTagService 
{
    @Autowired
    private GoodsTagMapper goodsTagMapper;

    /**
     * 查询商品标签
     * 
     * @param id 商品标签主键
     * @return 商品标签
     */
    @Override
    public GoodsTag selectGoodsTagById(String id)
    {
        return goodsTagMapper.selectGoodsTagById(id);
    }

    /**
     * 查询商品标签列表
     * 
     * @param goodsTag 商品标签
     * @return 商品标签
     */
    @Override
    public List<GoodsTag> selectGoodsTagList(GoodsTag goodsTag)
    {
        return goodsTagMapper.selectGoodsTagList(goodsTag);
    }

    /**
     * 新增商品标签
     * 
     * @param goodsTag 商品标签
     * @return 结果
     */
    @Override
    public int insertGoodsTag(GoodsTag goodsTag)
    {
        return goodsTagMapper.insertGoodsTag(goodsTag);
    }

    /**
     * 修改商品标签
     * 
     * @param goodsTag 商品标签
     * @return 结果
     */
    @Override
    public int updateGoodsTag(GoodsTag goodsTag)
    {
        return goodsTagMapper.updateGoodsTag(goodsTag);
    }

    /**
     * 批量删除商品标签
     * 
     * @param ids 需要删除的商品标签主键
     * @return 结果
     */
    @Override
    public int deleteGoodsTagByIds(String[] ids)
    {
        return goodsTagMapper.deleteGoodsTagByIds(ids);
    }

    /**
     * 删除商品标签信息
     * 
     * @param id 商品标签主键
     * @return 结果
     */
    @Override
    public int deleteGoodsTagById(String id)
    {
        return goodsTagMapper.deleteGoodsTagById(id);
    }
}
