package com.soss.system.service.impl;

import java.util.Date;
import java.util.List;

import com.soss.common.exception.ServiceException;
import com.soss.system.service.IMachineService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.MachineMapper;
import com.soss.system.domain.Machine;

/**
 * 机器Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class MachineServiceImpl implements IMachineService
{
    @Autowired
    private MachineMapper machineMapper;

    /**
     * 查询机器
     * 
     * @param id 机器主键
     * @return 机器
     */
    @Override
    public Machine selectMachineById(String id)
    {
        return machineMapper.selectMachineById(id);
    }

    /**
     * 查询机器列表
     * 
     * @param machine 机器
     * @return 机器
     */
    @Override
    public List<Machine> selectMachineList(Machine machine)
    {
        return machineMapper.selectMachineList(machine);
    }

    /**
     * 新增机器
     * 
     * @param machine 机器
     * @return 结果
     */
    @Override
    public int insertMachine(Machine machine)
    {
        return machineMapper.insertMachine(machine);
    }

    /**
     * 修改机器
     * 
     * @param machine 机器
     * @return 结果
     */
    @Override
    public int updateMachine(Machine machine)
    {
        return machineMapper.updateMachine(machine);
    }

    /**
     * 批量删除机器
     * 
     * @param ids 需要删除的机器主键
     * @return 结果
     */
    @Override
    public int deleteMachineByIds(String[] ids)
    {
        return machineMapper.deleteMachineByIds(ids);
    }

    /**
     * 删除机器信息
     * 
     * @param id 机器主键
     * @return 结果
     */
    @Override
    public int deleteMachineById(String id)
    {
        return machineMapper.deleteMachineById(id);
    }

    @Override
    public String bindMachine(String code, Long shopId) {
        Machine machine = new Machine();
        machine.setShopId(shopId);
        List<Machine> machines = machineMapper.selectMachineList(machine);
        if(!machines.isEmpty()){
            throw new ServiceException("目前只允许一个店铺绑定一台机器");
        }
        Machine machine1 = machineMapper.selectMachineByCode(code);
        if(machine1 ==null){
            machine.setCode(code);
            machine.setBindTime(new Date());
            machine.setCreatedAt(new Date());
            machine.setUpdatedAt(new Date());
            machine.setState("1");
            return  machineMapper.insertMachine(machine)+"";
        }
        if(machine1.getShopId()!=null){
            throw new ServiceException("该机器已经被绑定，请先解绑再绑定");
        }
        machine1.setCode(code);
        machine1.setShopId(shopId);
        machineMapper.updateMachine(machine1);
        return "1";
    }

    @Override
    public int unbound(String id) {
        return machineMapper.deleteMachineById(id);
    }

    public Machine selectMachineByCode(String machineCode) {
        return machineMapper.selectMachineByCode(machineCode);
    }
}
