package com.soss.system.service.impl;

import java.util.Date;
import java.util.List;

import com.soss.common.core.domain.AjaxResult;
import com.soss.common.utils.GenerateCode;
import com.soss.system.domain.SpecRuleMaterial;
import com.soss.system.service.IMaterialService;
import com.soss.system.mapper.SpecMapper;
import com.soss.system.mapper.SpecRuleMaterialMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.MaterialMapper;
import com.soss.system.domain.Material;

/**
 * 原料Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class MaterialServiceImpl implements IMaterialService
{
    @Autowired
    private MaterialMapper materialMapper;

    @Autowired
    private SpecRuleMaterialMapper specRuleMaterialMapper;
    @Autowired
    private SpecMapper specMapper;

    /**
     * 查询原料
     * 
     * @param id 原料主键
     * @return 原料
     */
    @Override
    public Material selectMaterialById(String id)
    {
        return materialMapper.selectMaterialById(id);
    }

    /**
     * 查询原料列表
     * 
     * @param material 原料
     * @return 原料
     */
    @Override
    public List<Material> selectMaterialList(Material material)
    {
        return materialMapper.selectMaterialList(material);
    }

    /**
     * 新增原料
     * 
     * @param material 原料
     * @return 结果
     */
    @Override
    public Long insertMaterial(Material material)
    {
        material.setCreatedAt(new Date());
        material.setUpdatedAt(new Date());
        material.setCode(GenerateCode.getCode("RM"));
        long i =  materialMapper.insertMaterial(material);
        return material.getId();
    }

    /**
     * 修改原料
     * 
     * @param material 原料
     * @return 结果
     */
    @Override
    public AjaxResult updateMaterial(Material material)
    {
        //查询原料有无在使用
        if("2".equals(material.getState())){
            SpecRuleMaterial specRuleMaterial = new SpecRuleMaterial();
            specRuleMaterial.setMaterialId(material.getId());
            specRuleMaterial.setIsDeleted("0");
            int i = specRuleMaterialMapper.selectSpecRuleMaterialList(specRuleMaterial).size();
            if(i>0){
                return AjaxResult.error("有规格正在使用此原料，请取消关联后再操作");
            }
        }
        material.setUpdatedAt(new Date());
        return AjaxResult.success(materialMapper.updateMaterial(material));


    }

    /**
     * 批量删除原料
     * 
     * @param ids 需要删除的原料主键
     * @return 结果
     */
    @Override
    public int deleteMaterialByIds(String[] ids)
    {
        if(ids.length>0){
            for (String id : ids) {
                specRuleMaterialMapper.deleteSpecRuleMaterialByMaterialId(id);
            }


        }
        return materialMapper.deleteMaterialByIds(ids);
    }

    /**
     * 删除原料信息
     * 
     * @param id 原料主键
     * @return 结果
     */
    @Override
    public AjaxResult deleteMaterialById(String id)
    {
        //查询原料有无在使用

            SpecRuleMaterial specRuleMaterial = new SpecRuleMaterial();
            specRuleMaterial.setMaterialId(Long.parseLong(id));
            specRuleMaterial.setIsDeleted("0");
            int i = specRuleMaterialMapper.selectSpecRuleMaterialList(specRuleMaterial).size();
            if(i>0){
                return AjaxResult.error("有规格正在使用此原料，请取消关联后再操作");
            }else{
                return AjaxResult.success(materialMapper.deleteMaterialById(id));
            }


    }

    @Override
    public boolean selectMaterialIsUserd(String[] ids) {
        if(ids.length>0){
            for (String id : ids) {
                SpecRuleMaterial specRuleMaterial = new SpecRuleMaterial();
                specRuleMaterial.setMaterialId(Long.parseLong(id));
                int i = specRuleMaterialMapper.selectSpecRuleMaterialList(specRuleMaterial).size();
                if(i>0){
                    return true;
                }
            }
        }
        return false;

    }


}
