package com.soss.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.OrderLogMapper;
import com.soss.system.domain.OrderLog;
import com.soss.system.service.IOrderLogService;

/**
 * 订单日志Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class OrderLogServiceImpl implements IOrderLogService 
{
    @Autowired
    private OrderLogMapper orderLogMapper;

    /**
     * 查询订单日志
     * 
     * @param id 订单日志主键
     * @return 订单日志
     */
    @Override
    public OrderLog selectOrderLogById(String id)
    {
        return orderLogMapper.selectOrderLogById(id);
    }

    /**
     * 查询订单日志列表
     * 
     * @param orderLog 订单日志
     * @return 订单日志
     */
    @Override
    public List<OrderLog> selectOrderLogList(OrderLog orderLog)
    {
        return orderLogMapper.selectOrderLogList(orderLog);
    }

    /**
     * 新增订单日志
     * 
     * @param orderLog 订单日志
     * @return 结果
     */
    @Override
    public int insertOrderLog(OrderLog orderLog)
    {
        return orderLogMapper.insertOrderLog(orderLog);
    }

    /**
     * 修改订单日志
     * 
     * @param orderLog 订单日志
     * @return 结果
     */
    @Override
    public int updateOrderLog(OrderLog orderLog)
    {
        return orderLogMapper.updateOrderLog(orderLog);
    }

    /**
     * 批量删除订单日志
     * 
     * @param ids 需要删除的订单日志主键
     * @return 结果
     */
    @Override
    public int deleteOrderLogByIds(String[] ids)
    {
        return orderLogMapper.deleteOrderLogByIds(ids);
    }

    /**
     * 删除订单日志信息
     * 
     * @param id 订单日志主键
     * @return 结果
     */
    @Override
    public int deleteOrderLogById(String id)
    {
        return orderLogMapper.deleteOrderLogById(id);
    }
}
