package com.soss.system.service.impl;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.soss.system.domain.Order;
import com.soss.system.domain.OrderDetail;
import com.soss.system.mapper.GoodsMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.OrderSnapshotMapper;
import com.soss.system.domain.OrderSnapshot;
import com.soss.system.service.IOrderSnapshotService;

/**
 * 订单快照Service业务层处理
 * 
 * @author zxq
 * @date 2022-05-22
 */
@Service
public class OrderSnapshotServiceImpl implements IOrderSnapshotService 
{
    @Autowired
    private OrderSnapshotMapper orderSnapshotMapper;
    @Autowired
    private GoodsMapper goodsMapper;

    /**
     * 查询订单快照
     * 
     * @param orderId 订单快照主键
     * @return 订单快照
     */
    @Override
    public OrderSnapshot selectOrderSnapshotByOrderId(Long orderId)
    {
        return orderSnapshotMapper.selectOrderSnapshotByOrderId(orderId);
    }

    /**
     * 查询订单快照列表
     * 
     * @param orderSnapshot 订单快照
     * @return 订单快照
     */
    @Override
    public List<OrderSnapshot> selectOrderSnapshotList(OrderSnapshot orderSnapshot)
    {
        return orderSnapshotMapper.selectOrderSnapshotList(orderSnapshot);
    }

    /**
     * 新增订单快照
     * 
     * @param orderSnapshot 订单快照
     * @return 结果
     */
    @Override
    public int insertOrderSnapshot(OrderSnapshot orderSnapshot)
    {
        return orderSnapshotMapper.insertOrderSnapshot(orderSnapshot);
    }

    /**
     * 修改订单快照
     * 
     * @param orderSnapshot 订单快照
     * @return 结果
     */
    @Override
    public int updateOrderSnapshot(OrderSnapshot orderSnapshot)
    {
        return orderSnapshotMapper.updateOrderSnapshot(orderSnapshot);
    }

    /**
     * 批量删除订单快照
     * 
     * @param orderIds 需要删除的订单快照主键
     * @return 结果
     */
    @Override
    public int deleteOrderSnapshotByOrderIds(String[] orderIds)
    {
        return orderSnapshotMapper.deleteOrderSnapshotByOrderIds(orderIds);
    }

    /**
     * 删除订单快照信息
     * 
     * @param orderId 订单快照主键
     * @return 结果
     */
    @Override
    public int deleteOrderSnapshotByOrderId(String orderId)
    {
        return orderSnapshotMapper.deleteOrderSnapshotByOrderId(orderId);
    }

    @Override
    public void saveOrderSnapshot(Order order) {
        List<OrderDetail> orderDetails = order.getOrderDetails();
        Long orderId = null;
        if(orderDetails!=null && !orderDetails.isEmpty()){
            for (OrderDetail orderDetail : orderDetails) {
                orderId = orderDetail.getOrderId();
                orderDetail.setGoods(goodsMapper.selectGoodsById(orderDetail.getGoodsId()));
            }
            String s = JSONObject.toJSONString(orderDetails);
            OrderSnapshot orderSnapshot = new OrderSnapshot();
            orderSnapshot.setOrderId(orderId);
            orderSnapshot.setSnapshot(s);
            orderSnapshotMapper.insertOrderSnapshot(orderSnapshot);

        }


    }
}
