package com.soss.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.soss.common.exception.ServiceException;
import com.soss.system.domain.*;
import com.soss.system.domain.vo.orderTaking.*;
import com.soss.system.mapper.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class OrderTakingServiceImpl {

    @Autowired
    private SysConfigServiceImpl sysConfigService;
    @Autowired
    private MachineMapper machineMapper;
    @Autowired
    private ShopRecommendMapper shopRecommendMapper;
    @Autowired
    private GoodsTagMapper goodsTagMapper;
    @Autowired
    private ShopGoodsSkuMapper shopGoodsSkuMapper;
    @Autowired
    private ShopGoodsMapper shopGoodsMapper;
    @Autowired
    private GoodsCategoryMapper goodsCategoryMapper;
    @Autowired
    private ShopMapper shopMapper;


    /**
     * 获取机器上的点单信息
     * @param machineCode
     * @return
     */
    public OrderTakingVo getMachineInfo(String machineCode) {

         Machine machine = machineMapper.selectMachineByCode(machineCode);
        if(machine==null || machine.getShopId() ==null){
            throw new ServiceException("该机器没有绑定店铺");
        }
        return this.getOrderTakingInfo(machine.getShopId());


    }

    public OrderTakingVo getInfoByShop(String shopId) {
        return this.getOrderTakingInfo(Long.parseLong(shopId));

    }

    public OrderTakingVo getOrderTakingInfo(Long shopId){
        OrderTakingVo orderTakingVo = new OrderTakingVo();
        Shop shop = shopMapper.selectShopById(String.valueOf(shopId));
        if(shop ==null){
            return orderTakingVo;
        }
        orderTakingVo.setShopState(shop.getState());
        ImagesVo imagesVo = new ImagesVo();
        orderTakingVo.setImages(imagesVo);
        imagesVo.setLeft(sysConfigService.selectConfigByKey("menu.left"));
        imagesVo.setRight(JSONObject.parseObject(sysConfigService.selectConfigByKey("menu.right")));
        orderTakingVo.setCountOfOrder(sysConfigService.selectConfigByKey("goods.limit"));
        orderTakingVo.setTips(sysConfigService.selectConfigByKey("tips.address"));
        List<CategoryVo> categoryVos = new ArrayList<>();
        CategoryVo preferentialCategoryVo = new CategoryVo();
        categoryVos.add(preferentialCategoryVo);
        preferentialCategoryVo.setId(0L);
        preferentialCategoryVo.setName("今日特惠");
        //查询出该店铺今日特惠的商品
        List<GoodsVo> goodsVos = shopRecommendMapper.selectShopGoodsByTyepe("2",shopId);
        preferentialCategoryVo.setGoods(goodsVos);
        if(!CollectionUtils.isEmpty(goodsVos)){
            for (GoodsVo goodsVo : goodsVos) {
                GoodsTag goodsTag = new GoodsTag();
                goodsTag.setState("1");
                goodsVo.setSpecs(buildGoodsSpec(goodsVo.getSpecString()));
                goodsVo.setSpecString(null);
                goodsTag.setGoodsId(Long.parseLong(goodsVo.getGoodsId()));
                goodsVo.setPics(JSONObject.parseObject(goodsVo.getPictures()));
                goodsVo.setPictures(null);
                List<GoodsTag> goodsTags = goodsTagMapper.selectGoodsTagList(goodsTag);
                List<String> tags = goodsTags.stream().map(GoodsTag::getTag).collect(Collectors.toList());
                goodsVo.setTags(tags);
                //获取产品信息
                List<SkuVo> skuVos = shopGoodsSkuMapper.selectSkuByGoodAndShop(shopId, goodsVo.getGoodsId());
                buildSkuRules(skuVos);
                goodsVo.setSkus(skuVos);
            }
        }
        //推荐
        List<String> recommendGoodsId = new ArrayList<>();
        List<RecommendVo> recommendVos = new ArrayList<>();
        List<GoodsVo> recommendGoods = shopRecommendMapper.selectShopGoodsByTyepe("1", shopId);

        for (GoodsVo goodsVo : recommendGoods) {
            RecommendVo recommendVo = new RecommendVo();
            recommendVos.add(recommendVo);
            ShopRecommend shopRecommend = new ShopRecommend();
            shopRecommend.setShopId(String.valueOf(shopId));
            shopRecommend.setGoodsId(goodsVo.getGoodsId());
            shopRecommend.setType("1");
            ShopRecommend shopRecommend1 = shopRecommendMapper.selectShopRecommendList(shopRecommend).get(0);
            recommendVo.setTitle(shopRecommend1.getName());
            recommendVo.setDesc(shopRecommend1.getDesc());
            recommendVo.setGoodsName(shopRecommend1.getGoodsName());
            recommendVo.setPic(shopRecommend1.getPic());
            recommendVo.setGoods(goodsVo);
            goodsVo.setSpecs(buildGoodsSpec(goodsVo.getSpecString()));
            goodsVo.setSpecString(null);
            goodsVo.setPics(JSONObject.parseObject(goodsVo.getPictures()));
            goodsVo.setPictures(null);
            recommendGoodsId.add(goodsVo.getGoodsId());
            GoodsTag goodsTag = new GoodsTag();
            goodsTag.setState("1");
            goodsTag.setGoodsId(Long.parseLong(goodsVo.getGoodsId()));
            List<GoodsTag> goodsTags = goodsTagMapper.selectGoodsTagList(goodsTag);
            List<String> tags = goodsTags.stream().map(GoodsTag::getTag).collect(Collectors.toList());
            goodsVo.setTags(tags);
            //获取产品信息
            List<SkuVo> skuVos = shopGoodsSkuMapper.selectSkuByGoodAndShop(shopId, goodsVo.getGoodsId());
            buildSkuRules(skuVos);
            goodsVo.setSkus(skuVos);
        }
        //普通分类的产品

        List<GoodsCategory> shopCategories = goodsCategoryMapper.selectByShopId(shopId);
        if(!CollectionUtils.isEmpty(shopCategories)){
            for (GoodsCategory category : shopCategories) {
                CategoryVo categoryVo = new CategoryVo();
                categoryVo.setId(Long.parseLong(category.getId()));
                categoryVo.setName(category.getName());
                List<Goods> goodsList = shopGoodsMapper.selectShopCategoryGoodsByCategoryId(shopId, category.getId());
                List<GoodsVo> goodsVoList = new ArrayList<>();
                categoryVo.setGoods(goodsVoList);
                if(!CollectionUtils.isEmpty(goodsList)){
                    for (Goods good : goodsList) {
                        GoodsVo goodsVo =new GoodsVo();
                        goodsVo.setGoodsId(String.valueOf(good.getId()));
                        goodsVo.setName(good.getName());
                        goodsVo.setDesc(good.getDesc());
                        goodsVo.setDiscount(good.getDiscount().stripTrailingZeros().toPlainString());
                        goodsVo.setPrice(good.getPrice().stripTrailingZeros().toPlainString());
                        goodsVo.setPics(JSONObject.parseObject(good.getPics()));
                        goodsVo.setRemarks(good.getRemarks());
                        goodsVo.setSpecs(buildGoodsSpec(good.getSpec()));
                        goodsVo.setSpecString(null);
                        if(recommendGoodsId.contains(String.valueOf(good.getId()))){
                            goodsVo.setIsRecommend("1");
                        }else{
                            goodsVo.setIsRecommend("0");
                        }
                        GoodsTag goodsTag = new GoodsTag();
                        goodsTag.setState("1");
                        goodsTag.setGoodsId(Long.parseLong(goodsVo.getGoodsId()));
                        List<GoodsTag> goodsTags = goodsTagMapper.selectGoodsTagList(goodsTag);
                        List<String> tags = goodsTags.stream().map(GoodsTag::getTag).collect(Collectors.toList());
                        goodsVo.setTags(tags);
                        //获取产品信息
                        List<SkuVo> skuVos = shopGoodsSkuMapper.selectSkuByGoodAndShop(shopId, goodsVo.getGoodsId());
                        buildSkuRules(skuVos);
                        goodsVo.setSkus(skuVos);
                        goodsVoList.add(goodsVo);
                    }
                }

                categoryVos.add(categoryVo);
            }
        }


        orderTakingVo.setRecommends(recommendVos);
        orderTakingVo.setCategorys(categoryVos);
        return orderTakingVo;

    }

    private void buildSkuRules(List<SkuVo> skuVos) {
        if(CollectionUtils.isEmpty(skuVos)){
            return;
        }
        for (SkuVo skuVo : skuVos) {
            String rules = skuVo.getRulesString();
            List<SpecRule> specRuleList = JSONObject.parseArray(rules, SpecRule.class);
            boolean boo =true;
            List<SkuRuleVo> skuRuleVos = new ArrayList<>();
            for (SpecRule specRule : specRuleList) {
                SkuRuleVo skuRuleVo = new SkuRuleVo();
                skuRuleVos.add(skuRuleVo);
                skuRuleVo.setPrice(specRule.getAmount().stripTrailingZeros().toPlainString());
                skuRuleVo.setRuleId(String.valueOf(specRule.getId()));
                skuRuleVo.setSpecId(String.valueOf(specRule.getSpecId()));
                skuRuleVo.setRuleName(specRule.getName());
                if(0L == specRule.getIsDefault()){
                    boo =false;
                }
            }
            skuVo.setIsDefault("0");
            if(boo){
                skuVo.setIsDefault("1");
            }
            skuVo.setRules(JSONObject.parseArray(JSONObject.toJSONString(skuRuleVos)));
            skuVo.setRulesString(null);
        }
    }

   

    private JSONArray buildGoodsSpec(String specs) {
        List<Spec> specList = JSONObject.parseArray(specs,Spec.class);
        List<SpecVo> specVos = new ArrayList<>();
        for (Spec spec : specList) {
            SpecVo specVo = new SpecVo();
            specVos.add(specVo);
            specVo.setSpecId(String.valueOf(spec.getId()));
            specVo.setSpecName(spec.getName());
            List<SpecRuleVo> specRuleVos = new ArrayList<>();
            specVo.setRules(specRuleVos);
            for (SpecRule specRule : spec.getSpecRules()) {
                SpecRuleVo specRuleVo = new SpecRuleVo();
                specRuleVos.add(specRuleVo);
                specRuleVo.setRuleId(String.valueOf(specRule.getId()));
                specRuleVo.setPrice(specRule.getAmount().stripTrailingZeros().toPlainString());
                specRuleVo.setRuleName(specRule.getName());
                specRuleVo.setIsDefault(String.valueOf(specRule.getIsDefault()));
                specRuleVo.setIsRecommend(specRule.getIsRecommend());
            }

        }
        return JSONArray.parseArray(JSONObject.toJSONString(specVos));

    }

    /**
     * 机器点单屏信息
     * {
     *     "images": {
     *         "left": [
     *             "http://baidu.com",
     *             "http://baidu.com"
     *         ],
     *         "right": [
     *             {
     *                 "code": 1,
     *                 "url": "http://baidu.com"
     *             },
     *             {
     *                 "code": 1,
     *                 "url": "http://baidu.com"
     *             },
     *             {
     *                 "code": 1,
     *                 "url": "http://baidu.com"
     *             },
     *             {
     *                 "code": 1,
     *                 "url": "http://baidu.com"
     *             }
     *         ]
     *     },
     *     "tips": "http://baidu.com",
     *     "countOfOrder": 9,
     *     "categorys": [
     *         {
     *             "id": 1,
     *             "name": "今日特惠",
     *             "goods": [
     *                 {
     *                     "goodId": 100,
     *                     "name": "冰茶咖啡",
     *                     "price": 29.9,
     *                     "discount": 19.9,
     *                     "pics": {
     *                         "thumbnail": "http://baidu.com",
     *                         "introImages": [
     *                             "http://baidu.com",
     *                             "http://baidu.com",
     *                             "http://baidu.com"
     *                         ],
     *                         "detailImages": [
     *                             "http://baidu.com",
     *                             "http://baidu.com",
     *                             "http://baidu.com"
     *                         ]
     *                     },
     *                     "desc": "",
     *                     "remark": "",
     *                     "tags": [
     *                         "YYDS",
     *                         "杨幂同款"
     *                     ],
     *                     "specs": [
     *                         {
     *                             "specId": 1,
     *                             "specName": "温度",
     *                             "rules": [
     *                                 {
     *                                     "ruleId": 1,
     *                                     "ruleName": "常温",
     *                                     "price": 0
     *                                 },
     *                                 {
     *                                     "ruleId": 2,
     *                                     "ruleName": "加冰",
     *                                     "price": 2
     *                                 },
     *                                 {
     *                                     "ruleId": 3,
     *                                     "ruleName": "加热",
     *                                     "price": 3
     *                                 }
     *                             ]
     *                         },
     *                         {
     *                             "specId": 2,
     *                             "specName": "糖度",
     *                             "rules": [
     *                                 {
     *                                     "ruleId": 4,
     *                                     "ruleName": "无糖",
     *                                     "price": 0
     *                                 },
     *                                 {
     *                                     "ruleId": 5,
     *                                     "ruleName": "少糖",
     *                                     "price": 1
     *                                 },
     *                                 {
     *                                     "ruleId": 6,
     *                                     "ruleName": "多糖",
     *                                     "price": 2
     *                                 }
     *                             ]
     *                         }
     *                     ],
     *                     "skus": [
     *                         {
     *                             "skuId": 1,
     *                             "state": 1,
     *                             "rules": [
     *                                 {
     *                                     "specId": 1,
     *                                     "specName": "温度",
     *                                     "ruleId": 1,
     *                                     "ruleName": "常温",
     *                                     "price": 0.00
     *                                 },
     *                                 {
     *                                     "specId": 2,
     *                                     "specName": "糖度",
     *                                     "ruleId": 3,
     *                                     "ruleName": "无糖",
     *                                     "price": 0.00
     *                                 }
     *                             ]
     *                         },
     *                         {
     *                             "skuId": 1,
     *                             "state": 1,
     *                             "rules": [
     *                                 {
     *                                     "specId": 1,
     *                                     "specName": "温度",
     *                                     "ruleId": 2,
     *                                     "ruleName": "冰",
     *                                     "price": 2.00
     *                                 },
     *                                 {
     *                                     "specId": 2,
     *                                     "specName": "糖度",
     *                                     "ruleId": 3,
     *                                     "ruleName": "无糖",
     *                                     "price": 0.00
     *                                 }
     *                             ]
     *                         },
     *                         {
     *                             "skuId": 1,
     *                             "state": 1,
     *                             "rules": [
     *                                 {
     *                                     "specId": 1,
     *                                     "specName": "温度",
     *                                     "ruleId": 1,
     *                                     "ruleName": "常温",
     *                                     "price": 0.00
     *                                 },
     *                                 {
     *                                     "specId": 2,
     *                                     "specName": "糖度",
     *                                     "ruleId": 3,
     *                                     "ruleName": "加糖",
     *                                     "price": 2.00
     *                                 }
     *                             ]
     *                         },
     *                         {
     *                             "skuId": 1,
     *                             "state": 1,
     *                             "rules": [
     *                                 {
     *                                     "specId": 1,
     *                                     "specName": "温度",
     *                                     "ruleId": 1,
     *                                     "ruleName": "冰",
     *                                     "price": 2.00
     *                                 },
     *                                 {
     *                                     "specId": 2,
     *                                     "specName": "糖度",
     *                                     "ruleId": 3,
     *                                     "ruleName": "加糖",
     *                                     "price": 4.00
     *                                 }
     *                             ]
     *                         }
     *                     ]
     *                 }
     *             ]
     *         }
     *     ],
     *     "recommends": [
     *         {
     *             "goodsName": "推荐名称",
     *             "pic": "http://baidu.com",
     *             "desc": "推荐描述",
     *             "goods": [
     *                 {
     *                     "goodId": 100,
     *                     "name": "冰茶咖啡",
     *                     "price": 29.9,
     *                     "discount": 19.9,
     *                     "pics": {
     *                         "thumbnail": "http://baidu.com",
     *                         "introImages": [
     *                             "http://baidu.com",
     *                             "http://baidu.com",
     *                             "http://baidu.com"
     *                         ],
     *                         "detailImages": [
     *                             "http://baidu.com",
     *                             "http://baidu.com",
     *                             "http://baidu.com"
     *                         ]
     *                     },
     *                     "desc": "",
     *                     "remark": "",
     *                     "tags": [
     *                         "YYDS",
     *                         "杨幂同款"
     *                     ],
     *                     "specs": [
     *                         {
     *                             "specId": 1,
     *                             "specName": "温度",
     *                             "rules": [
     *                                 {
     *                                     "ruleId": 1,
     *                                     "ruleName": "常温",
     *                                     "price": 0
     *                                 },
     *                                 {
     *                                     "ruleId": 2,
     *                                     "ruleName": "加冰",
     *                                     "price": 2
     *                                 },
     *                                 {
     *                                     "ruleId": 3,
     *                                     "ruleName": "加热",
     *                                     "price": 3
     *                                 }
     *                             ]
     *                         }
     *                     ],
     *                     "skus": [
     *                         {
     *                             "skuId": 1,
     *                             "state": 1,
     *                             "rules": [
     *                                 {
     *                                     "specId": 1,
     *                                     "specName": "温度",
     *                                     "ruleId": 1,
     *                                     "ruleName": "常温",
     *                                     "price": 0.00
     *                                 },
     *                                 {
     *                                     "specId": 2,
     *                                     "specName": "糖度",
     *                                     "ruleId": 3,
     *                                     "ruleName": "无糖",
     *                                     "price": 0.00
     *                                 }
     *                             ]
     *                         }
     *                     ]
     *                 }
     *             ]
     *         }
     *     ]
     * }
     */
}
