package com.soss.system.service.impl;

import java.util.List;

import com.soss.system.service.IShopGoodsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.ShopGoodsMapper;
import com.soss.system.domain.ShopGoods;

/**
 * 店铺和商品关联Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class ShopGoodsServiceImpl implements IShopGoodsService
{
    @Autowired
    private ShopGoodsMapper shopGoodsMapper;

    /**
     * 查询店铺和商品关联
     * 
     * @param id 店铺和商品关联主键
     * @return 店铺和商品关联
     */
    @Override
    public ShopGoods selectShopGoodsById(String id)
    {
        return shopGoodsMapper.selectShopGoodsById(id);
    }

    /**
     * 查询店铺和商品关联列表
     * 
     * @param shopGoods 店铺和商品关联
     * @return 店铺和商品关联
     */
    @Override
    public List<ShopGoods> selectShopGoodsList(ShopGoods shopGoods)
    {
        return shopGoodsMapper.selectShopGoodsList(shopGoods);
    }

    /**
     * 新增店铺和商品关联
     * 
     * @param shopGoods 店铺和商品关联
     * @return 结果
     */
    @Override
    public int insertShopGoods(ShopGoods shopGoods)
    {
        return shopGoodsMapper.insertShopGoods(shopGoods);
    }

    /**
     * 修改店铺和商品关联
     * 
     * @param shopGoods 店铺和商品关联
     * @return 结果
     */
    @Override
    public int updateShopGoods(ShopGoods shopGoods)
    {
        return shopGoodsMapper.updateShopGoods(shopGoods);
    }

    /**
     * 批量删除店铺和商品关联
     * 
     * @param ids 需要删除的店铺和商品关联主键
     * @return 结果
     */
    @Override
    public int deleteShopGoodsByIds(String[] ids)
    {
        return shopGoodsMapper.deleteShopGoodsByIds(ids);
    }

    /**
     * 删除店铺和商品关联信息
     * 
     * @param id 店铺和商品关联主键
     * @return 结果
     */
    @Override
    public int deleteShopGoodsById(String id)
    {
        return shopGoodsMapper.deleteShopGoodsById(id);
    }
}
