package com.soss.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.ShopGoodsSkuMapper;
import com.soss.system.domain.ShopGoodsSku;
import com.soss.system.service.IShopGoodsSkuService;

/**
 * 从店铺到sku关联Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class ShopGoodsSkuServiceImpl implements IShopGoodsSkuService 
{
    @Autowired
    private ShopGoodsSkuMapper shopGoodsSkuMapper;

    /**
     * 查询从店铺到sku关联
     * 
     * @param id 从店铺到sku关联主键
     * @return 从店铺到sku关联
     */
    @Override
    public ShopGoodsSku selectShopGoodsSkuById(String id)
    {
        return shopGoodsSkuMapper.selectShopGoodsSkuById(id);
    }

    /**
     * 查询从店铺到sku关联列表
     * 
     * @param shopGoodsSku 从店铺到sku关联
     * @return 从店铺到sku关联
     */
    @Override
    public List<ShopGoodsSku> selectShopGoodsSkuList(ShopGoodsSku shopGoodsSku)
    {
        return shopGoodsSkuMapper.selectShopGoodsSkuList(shopGoodsSku);
    }

    /**
     * 新增从店铺到sku关联
     * 
     * @param shopGoodsSku 从店铺到sku关联
     * @return 结果
     */
    @Override
    public int insertShopGoodsSku(ShopGoodsSku shopGoodsSku)
    {
        return shopGoodsSkuMapper.insertShopGoodsSku(shopGoodsSku);
    }

    /**
     * 修改从店铺到sku关联
     * 
     * @param shopGoodsSku 从店铺到sku关联
     * @return 结果
     */
    @Override
    public int updateShopGoodsSku(ShopGoodsSku shopGoodsSku)
    {
        return shopGoodsSkuMapper.updateShopGoodsSku(shopGoodsSku);
    }

    /**
     * 批量删除从店铺到sku关联
     * 
     * @param ids 需要删除的从店铺到sku关联主键
     * @return 结果
     */
    @Override
    public int deleteShopGoodsSkuByIds(String[] ids)
    {
        return shopGoodsSkuMapper.deleteShopGoodsSkuByIds(ids);
    }

    /**
     * 删除从店铺到sku关联信息
     * 
     * @param id 从店铺到sku关联主键
     * @return 结果
     */
    @Override
    public int deleteShopGoodsSkuById(String id)
    {
        return shopGoodsSkuMapper.deleteShopGoodsSkuById(id);
    }
}
