package com.soss.system.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.exception.ServiceException;
import com.soss.common.utils.StringUtils;
import com.soss.system.domain.*;
import com.soss.system.service.IShopService;
import com.soss.system.mapper.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.core.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 店铺Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
@Slf4j
public class ShopServiceImpl implements IShopService
{
    @Autowired
    private ShopMapper shopMapper;
    @Autowired
    private MachineMapper machineMapper;
    @Autowired
    private GoodsSkuMapper goodsSkuMapper;
    @Autowired
    private ShopGoodsMapper shopGoodsMapper;
    @Autowired
    private ShopGoodsSkuMapper shopGoodsSkuMapper;
    @Autowired
    private GoodsCategoryMapper goodsCategoryMapper;

    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private ShopRecommendMapper shopRecommendMapper;




    /**
     * 查询店铺
     * 
     * @param id 店铺主键
     * @return 店铺
     */
    @Override
    public Shop selectShopById(String id)
    {
        return shopMapper.selectShopById(id);
    }

    /**
     * 查询店铺列表
     * 
     * @param shop 店铺
     * @return 店铺
     */
    @Override
    public List<Shop> selectShopList(Shop shop)
    {
        List<Shop> shops = shopMapper.selectShopList(shop);
        for (Shop shop1 : shops) {
            Machine machine = new Machine();
            machine.setShopId(shop1.getId());
            shop1.setMachineCount(machineMapper.selectMachineList(machine).size());
            shop1.setSalesAmount(orderMapper.selectSalesAmount(shop1.getId()));
            shop1.setSalesVolume(orderMapper.selectSalesVolume(shop1.getId(),null));

            //shop1.setMachieStatus(machineMapper.selectMachineList(machine).get(0).getState());
        }

        return shops;
    }

    /**
     * 新增店铺
     * 
     * @param shop 店铺
     * @return 结果
     */
    @Override
    public long insertShop(Shop shop)
    {
        shop.setCreatedAt(new Date());
        shop.setUpdatedAt(new Date());
        shop.setIsDefault(0L);
        shopMapper.insertShop(shop);
        return shop.getId();
    }

    /**
     * 修改店铺
     * 
     * @param shop 店铺
     * @return 结果
     */
    @Override
    public int updateShop(Shop shop)
    {
        shop.setUpdatedAt(new Date());
        if(1 == shop.getIsDefault()){
            shopMapper.updateNoDefault();
        }
        return shopMapper.updateShop(shop);
    }

    /**
     * 批量删除店铺
     * 
     * @param ids 需要删除的店铺主键
     * @return 结果
     */
    @Override
    public int deleteShopByIds(String[] ids)
    {
        for (String id : ids) {
            Shop shop = new Shop();
            shop.setId(Long.parseLong(id));
            shop.setState("3");
            shopMapper.updateShop(shop);
        }
        return 1;

    }

    /**
     * 删除店铺信息
     * 
     * @param id 店铺主键
     * @return 结果
     */
    @Override
    public int deleteShopById(String id)
    {
        return shopMapper.deleteShopById(id);
    }

    @Override
    public String addGoods(long shopId, String goodsIds) {
        String[] goodsIdString = goodsIds.split(",");
        for (String s : goodsIdString) {
            Long goodsId = Long.parseLong(s);
            addGoods(shopId,goodsId);

        }
        return null;
    }
    @Transactional
    public String addGoods(long shopId, Long goodsId) {
        ShopGoods shopGoods = new ShopGoods();
        shopGoods.setGoodsId(goodsId);
        shopGoods.setShopId(shopId);
        shopGoods.setUpdatedAt(new Date());
        shopGoods.setCreatedAt(new Date());
        shopGoodsMapper.insertShopGoods(shopGoods);
        shopGoods.setTurn(shopGoods.getId());
        shopGoodsMapper.updateShopGoods(shopGoods);
        GoodsSku goodsSku = new GoodsSku();
        goodsSku.setGoodsId(goodsId);
        goodsSku.setIsDeleted("0");
        List<GoodsSku> goodsSkus = goodsSkuMapper.selectGoodsSkuList(goodsSku);
        Machine machine = new Machine();
        machine.setShopId(shopId);
        List<Machine> machines = machineMapper.selectMachineList(machine);
        if(machines==null  ||machines.isEmpty()){
            throw new ServiceException("请先绑定机器");
        }
        for (Machine machine1 : machines) {
            for (GoodsSku skus : goodsSkus) {
                ShopGoodsSku shopGoodsSku = new ShopGoodsSku();
                shopGoodsSku.setGoodsId(goodsId);
                shopGoodsSku.setSkuId(skus.getId());
                shopGoodsSku.setShopId(shopId);
                shopGoodsSku.setState("1");
                shopGoodsSku.setIsDeleted("0");
                shopGoodsSku.setCreatedAt(new Date());
                shopGoodsSku.setUpdatedAt(new Date());
                shopGoodsSkuMapper.insertShopGoodsSku(shopGoodsSku);
            }
        }
        return null;
    }

    @Override
    public List<GoodsCategory>  getCategoryGoods(long shopId) {

        List<GoodsCategory> shopCategories = goodsCategoryMapper.selectByShopId(shopId);
        for (GoodsCategory category : shopCategories) {
            List<Goods> goodsList = shopGoodsMapper.selectShopCategoryGoodsByCategoryId(shopId,category.getId());

            for (Goods goods : goodsList) {
                ShopGoodsSku shopGoodsSku = new ShopGoodsSku();
                shopGoodsSku.setShopId(shopId);
                shopGoodsSku.setGoodsId(goods.getId());
                List<ShopGoodsSku> shopGoodsSkus = shopGoodsSkuMapper.selectShopGoodsSkuList(shopGoodsSku);
                if(!shopGoodsSkus.isEmpty()){
                    boolean boo= true;
                    for (ShopGoodsSku goodsSkus : shopGoodsSkus) {
                        if("2".equals(goodsSkus.getState())){
                            boo = false;
                        }
                    }
                    if(!boo){
                        goods.setState("2");
                    }
                }

                ShopRecommend shopRecommend = new ShopRecommend();
                shopRecommend.setShopId(String.valueOf(shopId));
                shopRecommend.setGoodsId(String.valueOf(goods.getId()));
                shopRecommend.setType("1");
                goods.setPreferential("1");
                goods.setRecommend("1");
                List<ShopRecommend> shopRecommends = shopRecommendMapper.selectShopRecommendList(shopRecommend);
                if(shopRecommends.size()>0){
                    goods.setRecommend("0");
                }
                shopRecommend.setType("2");
                shopRecommends = shopRecommendMapper.selectShopRecommendList(shopRecommend);
                if(shopRecommends.size()>0){
                    goods.setPreferential("0");
                }
                goods.setSalesVolume(orderMapper.selectSalesVolume(shopId,goods.getId()));
            }
            category.setGoodsList(goodsList);
        }
        return shopCategories;
    }

    @Override
    public List<GoodsSku> getSkuByGoodsId(long shopId, long goodsId) {
        return shopGoodsSkuMapper.selectSkuByShopAndGoods(shopId,goodsId);

    }

    @Override
    public String turn(Long shopId, Long goodsId, String pointer) {
        ShopGoods shopGoods = new ShopGoods();
        shopGoods.setShopId(shopId);
        Goods goods = goodsMapper.selectGoodsById(String.valueOf(goodsId));
        List<ShopGoods> shopGoodsList = shopGoodsMapper.selectShopGoodsList(shopGoods);
        shopGoodsList = shopGoodsList.stream().filter(e->{
            String category = goodsMapper.selectGoodsById(String.valueOf(e.getGoodsId())).getCategory();
            if(category.equals(goods.getCategory())){
                return true;
            }else{
                return false;
            }

        }).collect(Collectors.toList());

        int size = shopGoodsList.size();
        Long lastGoodsId = null;
        for(int i =0;i<size;i++){
            ShopGoods shopGood = shopGoodsList.get(i);
            if(goodsId.equals(shopGood.getGoodsId())){
                if("1".equals(pointer)){
                    int index = i-1;
                    if(index<0){
                        lastGoodsId =shopGood.getGoodsId();
                    }else{
                        lastGoodsId = shopGoodsList.get(index).getGoodsId();
                    }
                }else if("2".equals(pointer)){
                    int index=i+1;
                    if(index>=size){
                        lastGoodsId =shopGood.getGoodsId();
                    }else{
                        lastGoodsId = shopGoodsList.get(index).getGoodsId();
                    }
                }
            }
        }
        shopGoods.setGoodsId(goodsId);
        ShopGoods fristShopGoods = shopGoodsMapper.selectShopGoodsList(shopGoods).get(0);
        String turn = fristShopGoods.getTurn();
        shopGoods.setGoodsId(lastGoodsId);
        ShopGoods lastShopGoods = shopGoodsMapper.selectShopGoodsList(shopGoods).get(0);
        fristShopGoods.setTurn(lastShopGoods.getTurn());
        lastShopGoods.setTurn(turn);
        shopGoodsMapper.updateShopGoods(fristShopGoods);
        shopGoodsMapper.updateShopGoods(lastShopGoods);
        return null;
    }

    @Override
    public List<String> getShopCity() {
        List<Shop> shops = shopMapper.selectShopList(new Shop());
        List<String> collect = shops.stream().map(Shop::getCity).collect(Collectors.toList());
        return collect;
    }

    @Override
    public String offGoods(JSONObject body) {
        Long shopId = body.getLong("shopId");
        String string = body.getString("goodsIds");
        List<String> goodsIds = JSONObject.parseArray(string, String.class);
        shopGoodsSkuMapper.deleteByGoodsIds(shopId,goodsIds);
        shopGoodsMapper.deleteByShopIdGoods(shopId,goodsIds);
        shopRecommendMapper.deleteByShopIdGoods(shopId,goodsIds);
        return null;
    }

    @Override
    public List<Goods> selectGoodsList(String goodsName, String category, Long shopId) {
        List<Goods> goodsList = shopGoodsMapper.selectShopNoAddGoods(goodsName, category, shopId);
        for (Goods goods1 : goodsList) {
            GoodsCategory goodsCategory = goodsCategoryMapper.selectGoodsCategoryById(goods1.getCategory());
            if(goodsCategory !=null){
                goods1.setCategoryName(goodsCategory.getName());
            }
            int count = orderMapper.selectSalesVolume(null,goods1.getId());
            goods1.setSalesVolume(count);
        }
        return goodsList;

    }


    public AjaxResult checkSku(String shopId, String skuId, String machineCode) {
        ShopGoodsSku shopGoodsSku = new ShopGoodsSku();
        shopGoodsSku.setSkuId(Long.parseLong(skuId));
        if(StringUtils.isNotEmpty(shopId)){
            shopGoodsSku.setShopId(Long.parseLong(shopId));
        }
        if(StringUtils.isNotEmpty(machineCode)){
            Machine machine = new Machine();
            machine.setCode(machineCode);
            List<Machine> machines = machineMapper.selectMachineList(machine);
            if(machines ==null){
                return AjaxResult.error("机器不存在");
            }
            Machine machine1 = machines.get(0);
            if(machine1.getShopId() ==null){
                return AjaxResult.error("该机器暂未绑定店铺");
            }
            shopGoodsSku.setShopId(machine1.getShopId());
        }
        shopGoodsSku.setIsDeleted("0");
        List<ShopGoodsSku> shopGoodsSkus = shopGoodsSkuMapper.selectShopGoodsSkuList(shopGoodsSku);
        if(shopGoodsSkus ==null ||shopGoodsSkus.isEmpty()){
            return AjaxResult.error("该产品已经不存在");
        }else{
            ShopGoodsSku shopGoodsSku1 = shopGoodsSkus.get(0);
            if(!"1".equals(shopGoodsSku1.getState())){
                return AjaxResult.error("该产品已经告罄");
            }

        }
        return AjaxResult.success();


    }
}
