package com.soss.system.service.impl;

import java.util.Date;
import java.util.List;

import com.soss.common.exception.ServiceException;
import com.soss.common.utils.GenerateCode;
import com.soss.system.domain.GoodsSku;
import com.soss.system.domain.SpecRule;
import com.soss.system.domain.SpecRuleMaterial;
import com.soss.system.mapper.GoodsSkuMapper;
import com.soss.system.service.ISpecService;
import com.soss.system.mapper.SpecRuleMapper;
import com.soss.system.mapper.SpecRuleMaterialMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.SpecMapper;
import com.soss.system.domain.Spec;
import org.springframework.transaction.annotation.Transactional;

/**
 * 规格Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class SpecServiceImpl implements ISpecService
{
    @Autowired
    private SpecMapper specMapper;
    @Autowired
    private SpecRuleMapper specRuleMapper;
    @Autowired
    private SpecRuleMaterialMapper specRuleMaterialMapper;
    @Autowired
    private GoodsSkuMapper goodsSkuMapper;

    /**
     * 查询规格
     * 
     * @param id 规格主键
     * @return 规格
     */
    @Override
    public Spec selectSpecById(String id)
    {
        Spec spec = specMapper.selectSpecById(id);
        SpecRule specRule = new SpecRule();
        specRule.setSpecId(Long.parseLong(id));
        List<SpecRule> specRules = specRuleMapper.selectSpecRuleList(specRule);
        spec.setSpecRules(specRules);
        if(!specRules.isEmpty()){
            for (SpecRule rule : specRules) {
                SpecRuleMaterial specRuleMaterial = new SpecRuleMaterial();
                specRuleMaterial.setRuleId(rule.getId());
                rule.setSpecRuleMaterials(specRuleMaterialMapper.selectSpecRuleMaterialList(specRuleMaterial));
            }
        }
        return spec;
    }

    /**
     * 查询规格列表
     * 
     * @param spec 规格
     * @return 规格
     */
    @Override
    public List<Spec> selectSpecList(Spec spec)
    {
        List<Spec> specs = specMapper.selectSpecList(spec);
        if(specs!=null &&!specs.isEmpty()){
            for (Spec spec1 : specs) {
                SpecRule specRule = new SpecRule();
                specRule.setSpecId(spec1.getId());
                List<SpecRule> specRules = specRuleMapper.selectSpecRuleList(specRule);
                spec1.setSpecRules(specRules);
            }
        }
        return specs;
    }

    /**
     * 新增规格
     * 
     * @param spec 规格
     * @return 结果
     */
    @Override
    @Transactional
    public int insertSpec(Spec spec)
    {
        spec.setCode(GenerateCode.getCode("PS"));
        spec.setCreatedAt(new Date());
        spec.setIsDeleted(0);
        List<SpecRule> specRules = spec.getSpecRules();
        if(specRules != null &&specRules.size()>0){
            spec.setIsShow(1L);
        }else{
            spec.setIsShow(0L);
        }
        spec.setUpdatedAt(new Date());
        int i = specMapper.insertSpec(spec);
        long specId = spec.getId();
        if(spec.getIsShow()==1L){
            for (SpecRule specRule : specRules) {
                specRule.setSpecId(specId);
                specRule.setCreatedAt(new Date());
                specRule.setIsDeleted(0);
                specRule.setUpdatedAt(new Date());
                specRuleMapper.insertSpecRule(specRule);
                final long ruleId = specRule.getId();
                List<SpecRuleMaterial> specRuleMaterials = specRule.getSpecRuleMaterials();
                if(specRuleMaterials!=null &&!specRuleMaterials.isEmpty()){
                    for (SpecRuleMaterial specRuleMaterial : specRuleMaterials) {
                        specRuleMaterial.setRuleId(ruleId);
                        specRuleMaterial.setCreatedAt(new Date());
                        specRuleMaterial.setSpecId(specId);
                        specRuleMaterial.setIsDeleted("0");
                        specRuleMaterial.setCreatedAt(new Date());
                        specRuleMaterial.setUpdatedAt(new Date());
                        specRuleMaterial.setName(spec.getName());
                        specRuleMaterialMapper.insertSpecRuleMaterial(specRuleMaterial);
                    }
                }
            }
        }
        return i;

    }

    /**
     * 修改规格
     * 
     * @param spec 规格
     * @return 结果
     */
    @Override
    public int updateSpec(Spec spec)
    {
        if(2 == spec.getState()){
            String query ="\"specId\": "+spec.getId();
            List<GoodsSku> goodsSkus = goodsSkuMapper.selectSpec(query);
            if(!goodsSkus.isEmpty()){
                throw new ServiceException("当前还有商品使用，请先删除商品");
            }
        }
        spec.setIsDeleted(0);
        spec.setUpdatedAt(new Date());
        int i = specMapper.updateSpec(spec);
        List<SpecRule> specRules = spec.getSpecRules();
        if(specRules ==null || specRules.isEmpty()){
            return i;
        }
        specRuleMapper.deleteSpecRuleBySpecId(spec.getId());
        specRuleMaterialMapper.deleteSpecRuleMaterialBySpecId(spec.getId());
        if(specRules != null &&specRules.size()>0){
            spec.setIsShow(1L);
        }else{
            spec.setIsShow(0L);
        }

        long specId = spec.getId();
        if(spec.getIsShow()==1L){
            for (SpecRule specRule : specRules) {
                specRule.setSpecId(specId);
                specRule.setUpdatedAt(new Date());
                specRule.setIsDeleted(0);
                specRuleMapper.insertSpecRule(specRule);
                final long ruleId = specRule.getId();
                List<SpecRuleMaterial> specRuleMaterials = specRule.getSpecRuleMaterials();
                if(specRuleMaterials!=null &&!specRuleMaterials.isEmpty()){
                    for (SpecRuleMaterial specRuleMaterial : specRuleMaterials) {
                        specRuleMaterial.setRuleId(ruleId);
                        specRuleMaterial.setUpdatedAt(new Date());
                        specRuleMaterial.setSpecId(specId);
                        specRuleMaterial.setIsDeleted("0");
                        specRuleMaterial.setName(spec.getName());
                        specRuleMaterialMapper.insertSpecRuleMaterial(specRuleMaterial);
                    }
                }
            }
        }
        return 1;
    }

    /**
     * 批量删除规格
     * 
     * @param ids 需要删除的规格主键
     * @return 结果
     */
    @Override
    public int deleteSpecByIds(String[] ids)
    {
        return specMapper.deleteSpecByIds(ids);
    }

    /**
     * 删除规格信息
     * 
     * @param id 规格主键
     * @return 结果
     */
    @Override
    public int deleteSpecById(String id)
    {
        String query ="\"specId\": "+id;
        List<GoodsSku> goodsSkus = goodsSkuMapper.selectSpec(query);
        if(!goodsSkus.isEmpty()){
            throw new ServiceException("当前还有商品使用，请先删除商品");
        }
        long specId = Long.parseLong(id);
        specRuleMapper.deleteSpecRuleBySpecId(specId);
        specRuleMaterialMapper.deleteSpecRuleMaterialBySpecId(specId);
        Spec spec = specMapper.selectSpecById(id);
        spec.setIsDeleted(1);
        spec.setUpdatedAt(new Date());
        return specMapper.updateSpec(spec);
    }
}
