package com.soss.system.service.impl;

import java.util.Date;
import java.util.List;

import com.soss.system.service.IWechatMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.WechatMessageMapper;
import com.soss.system.domain.WechatMessage;

/**
 * 小程序信息发送Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class WechatMessageServiceImpl implements IWechatMessageService
{
    @Autowired
    private WechatMessageMapper wechatMessageMapper;

    /**
     * 查询小程序信息发送
     * 
     * @param id 小程序信息发送主键
     * @return 小程序信息发送
     */
    @Override
    public WechatMessage selectWechatMessageById(String id)
    {
        return wechatMessageMapper.selectWechatMessageById(id);
    }

    /**
     * 查询小程序信息发送列表
     * 
     * @param wechatMessage 小程序信息发送
     * @return 小程序信息发送
     */
    @Override
    public List<WechatMessage> selectWechatMessageList(WechatMessage wechatMessage)
    {
        List<WechatMessage> wechatMessages = wechatMessageMapper.selectWechatMessageList(wechatMessage);
        for (WechatMessage message : wechatMessages) {
            String[] split = message.getMessage().split(",");
            message.setTitle(split[0]);
            message.setTitle(split[1]);
        }
        return wechatMessages;
    }

    /**
     * 新增小程序信息发送
     * 
     * @param wechatMessage 小程序信息发送
     * @return 结果
     */
    @Override
    public int insertWechatMessage(WechatMessage wechatMessage)
    {
        return wechatMessageMapper.insertWechatMessage(wechatMessage);
    }

    @Override
    public int insertWechatMessage(String openId, String message) {
        WechatMessage wechatMessage = new WechatMessage();
        wechatMessage.setMessage(message);
        wechatMessage.setCreatedAt(new Date());
        wechatMessage.setState("0");
        wechatMessage.setIsRead("1");
        wechatMessage.setType("1");
        wechatMessage.setUserId(openId);
        wechatMessage.setUpdatedAt(new Date());
        return  wechatMessageMapper.insertWechatMessage(wechatMessage);
    }

    /**
     * 修改小程序信息发送
     * 
     * @param wechatMessage 小程序信息发送
     * @return 结果
     */
    @Override
    public int updateWechatMessage(WechatMessage wechatMessage)
    {
        WechatMessage update = new WechatMessage();
        update.setId( wechatMessage.getId());
        update.setUpdatedAt(new Date());
        update.setIsRead("2");
        return wechatMessageMapper.updateWechatMessage(update);
    }

    /**
     * 批量删除小程序信息发送
     * 
     * @param ids 需要删除的小程序信息发送主键
     * @return 结果
     */
    @Override
    public int deleteWechatMessageByIds(String[] ids)
    {
        return wechatMessageMapper.deleteWechatMessageByIds(ids);
    }

    /**
     * 删除小程序信息发送信息
     * 
     * @param id 小程序信息发送主键
     * @return 结果
     */
    @Override
    public int deleteWechatMessageById(String id)
    {
        return wechatMessageMapper.deleteWechatMessageById(id);
    }

    public String getMessageCount(String openId) {
        WechatMessage wechatMessage = new WechatMessage();
        wechatMessage.setUserId(openId);
        wechatMessage.setIsRead("1");
        List<WechatMessage> wechatMessages = wechatMessageMapper.selectWechatMessageList(wechatMessage);
        return wechatMessages.size()+"";

    }
}
