package com.soss.system.service.impl;

import java.util.List;

import com.soss.system.service.IWechatUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.WechatUserMapper;
import com.soss.system.domain.WechatUser;

/**
 * 微信用户小程序信息（用于发送消息）Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class WechatUserServiceImpl implements IWechatUserService
{
    @Autowired
    private WechatUserMapper wechatUserMapper;

    /**
     * 查询微信用户小程序信息（用于发送消息）
     * 
     * @param id 微信用户小程序信息（用于发送消息）主键
     * @return 微信用户小程序信息（用于发送消息）
     */
    @Override
    public WechatUser selectWechatUserById(String id)
    {
        return wechatUserMapper.selectWechatUserById(id);
    }

    /**
     * 查询微信用户小程序信息（用于发送消息）列表
     * 
     * @param wechatUser 微信用户小程序信息（用于发送消息）
     * @return 微信用户小程序信息（用于发送消息）
     */
    @Override
    public List<WechatUser> selectWechatUserList(WechatUser wechatUser)
    {
        return wechatUserMapper.selectWechatUserList(wechatUser);
    }

    /**
     * 新增微信用户小程序信息（用于发送消息）
     * 
     * @param wechatUser 微信用户小程序信息（用于发送消息）
     * @return 结果
     */
    @Override
    public int insertWechatUser(WechatUser wechatUser)
    {
        return wechatUserMapper.insertWechatUser(wechatUser);
    }

    /**
     * 修改微信用户小程序信息（用于发送消息）
     * 
     * @param wechatUser 微信用户小程序信息（用于发送消息）
     * @return 结果
     */
    @Override
    public int updateWechatUser(WechatUser wechatUser)
    {
        return wechatUserMapper.updateWechatUser(wechatUser);
    }

    /**
     * 批量删除微信用户小程序信息（用于发送消息）
     * 
     * @param ids 需要删除的微信用户小程序信息（用于发送消息）主键
     * @return 结果
     */
    @Override
    public int deleteWechatUserByIds(String[] ids)
    {
        return wechatUserMapper.deleteWechatUserByIds(ids);
    }

    /**
     * 删除微信用户小程序信息（用于发送消息）信息
     * 
     * @param id 微信用户小程序信息（用于发送消息）主键
     * @return 结果
     */
    @Override
    public int deleteWechatUserById(String id)
    {
        return wechatUserMapper.deleteWechatUserById(id);
    }
}
