package com.soss.system.weixin.util;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaSubscribeMessage;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.soss.common.utils.DateUtils;
import com.soss.system.domain.Order;
import com.soss.system.domain.Shop;
import com.soss.system.mapper.ShopMapper;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import org.aspectj.weaver.ast.Or;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@Slf4j
public class SendMessageUtils {
    @Autowired
    private WxMaService wxMaService;
    @Value("${weixin.templateId}")
    private String templateId;
    @Value("${weixin.pagePath}")
    private String pagePath;
    @Autowired
    private ShopMapper shopMapper;

    private String templateInfo="[{" +
            "\"status\": \"2\"," +
            "\"templateId\": \"1uErx-15S-3vuopXSvvsxCeM_Jd-1iZC-nXzd2yW3QU\"," +
            "\"param\": {" +
            "\"character_string1\": \"$.orderNum\"," +
            "\"thing2\": \"$.shop.name\"," +
            "\"thing12\": \"$.shop.address\"," +
            "\"time7\": \"now\"," +
            "\"thing6\": \"您的订单已经下单成功了~\"" +
            "}" +
            "}, {" +
            "\"status\": \"3\"," +
            "\"templateId\": \"Q4HDwBEvpTXpwtZktqWm4SZOTEuQK1x48xjqjD2GqyM\"," +
            "\"param\": {" +
            "\"thing1\": \"$.shop.name\"," +
            "\"date6\": \"now\"," +
            "\"thing5\": \"订单已经开始制作，即将可以享用美食!\"" +
            "}" +
            "}, {" +
            "\"status\": \"4\"," +
            "\"templateId\": \"Fu_CPIXa0cnJ4EDdVKqFQ3qqKJccMqt2oorI5mfNq74\"," +
            "\"param\": {" +
            "\"character_string4\": \"$.orderNum\"," +
            "\"thing2\": \"$.shop.name\"," +
            "\"thing7\": \"$.shop.address\"," +
            "\"time6\": \"now\"," +
            "\"thing11\": \"您的订单制作完成了，现在可以去取餐啦！\"" +
            "}" +
            "}]";
    /**
     * 设置会议订阅消息
     *
     * @param
     * @return 订阅会议消息
     */
    private  List<WxMaSubscribeMessage.MsgData> setMeetingMsg (Order order) {
        Shop shop = shopMapper.selectShopById(order.getShopId());
        List<WxMaSubscribeMessage.MsgData> dataList = new ArrayList<>();
        //这里要完全按照订阅消息模板详情去设置，thing1 ，thing2...不能变
        WxMaSubscribeMessage.MsgData data1 = new WxMaSubscribeMessage.MsgData();
        data1.setName("character_string1");
        data1.setValue(order.getOrderNo());
        dataList.add(data1);
        WxMaSubscribeMessage.MsgData data2 = new WxMaSubscribeMessage.MsgData();
        data2.setName("thing2");
        data2.setValue(shop.getName());
        dataList.add(data2);
        WxMaSubscribeMessage.MsgData data3 = new WxMaSubscribeMessage.MsgData();
        data3.setName("character_string4");
        data3.setValue(order.getOrderNum());
        dataList.add(data3);
        WxMaSubscribeMessage.MsgData data4 = new WxMaSubscribeMessage.MsgData();
        data4.setName("thing7");
        data4.setValue(shop.getAddress());
        dataList.add(data4);
        return dataList;
    }

    /**
     * 根据模板id发送消息
     *

     */
    public void sendWxMsg(Order order) {

        //骚操作在这里
            try {
                Map<String, Object> tempalte = getTempalte(order);
                if(tempalte ==null){
                    return;
                }

                WxMaSubscribeMessage.WxMaSubscribeMessageBuilder builder = WxMaSubscribeMessage.builder();
                //发送人openid
                builder.toUser(order.getUserId());
                //发送的模板id
                builder.templateId((String)tempalte.get("tempalte"));
                //消息主体
                builder.data((List<WxMaSubscribeMessage.MsgData>) tempalte.get("dataList"));
                //点击订阅消息的跳转链接（默认是正式发布的小程序页面，当然也可以通过参数进行控制）
                builder.page(pagePath);
                WxMaSubscribeMessage msg = builder.build();
                wxMaService.getMsgService().sendSubscribeMsg(msg);
            } catch (WxErrorException e) {
                log.error("会议通知发送失败，用户openId:{}, 错误码：{},错误信息：{}",
                        order.getUserId(), e.getError().getErrorCode(), e.getError().getErrorMsg());
                //发送失败就发送短信

            }

    }

    public Map<String,Object> getTempalte(Order order){
        JSONArray jsonArray = JSONArray.parseArray(templateInfo);
        Shop shop = shopMapper.selectShopById(order.getShopId());
        order.setShop(shop);
        String orderState = order.getState();
        Map<String,Object> result = null;
        for(int i =0 ;i<jsonArray.size();i++){
            JSONObject tempalte = jsonArray.getJSONObject(i);
            if(orderState.equals(tempalte.getString("status"))){
                List<WxMaSubscribeMessage.MsgData> dataList = new ArrayList<>();
                result = new HashMap();
                result.put("tempalte",tempalte.getString("templateId"));
                result.put("dataList",dataList);
                JSONObject params = tempalte.getJSONObject("param");
                params.forEach((key,value)->{
                    WxMaSubscribeMessage.MsgData data = new WxMaSubscribeMessage.MsgData();
                    dataList.add(data);
                    String valueString = (String) value;
                    data.setName(key);
                    if("now".equals(valueString)){
                        valueString = DateUtils.getTime();
                    }else if(valueString.startsWith("$")){
                        valueString = (String) JSONPath.eval(order,valueString);
                    }
                    data.setValue(valueString);
                });

            }

        }
        return result;

    }

}
