package com.soss.web.controller.coffee;

import com.soss.common.annotation.Log;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.core.page.TableDataInfo;
import com.soss.common.enums.BusinessType;
import com.soss.system.domain.Goods;
import com.soss.system.domain.ShopRecommend;
import com.soss.system.service.IGoodsService;
import com.soss.system.service.IShopRecommendService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 推荐和今日特惠Controller
 *
 * @author zxq
 * @date 2022-04-28
 */
@RestController
@RequestMapping("/system/recommend")
public class ShopRecommendController extends BaseController {
    @Autowired
    private IShopRecommendService shopRecommendService;
    @Autowired
    private IGoodsService goodsService;

    @GetMapping("/turn")
    public AjaxResult turn(Long shopId, String goodsId, String pointer, String type) {
        return AjaxResult.success(shopRecommendService.turn(shopId, goodsId, pointer, type));
    }

    /**
     * 查询推荐和今日特惠列表
     */
    // @PreAuthorize("@ss.hasPermi('system:recommend:list')")
    @GetMapping("/list")
    public TableDataInfo list(ShopRecommend shopRecommend) {
        startPage();
        List<Goods> list = shopRecommendService.selectShopRecommendList(shopRecommend);
        goodsService.resolverCategoryName(list);
        goodsService.resolverGoodsVolume(Long.parseLong(shopRecommend.getShopId()), list);
        return getDataTable(list);
    }

    /**
     * 获取推荐和今日特惠详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:recommend:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id) {
        return AjaxResult.success(shopRecommendService.selectShopRecommendById(id));
    }

    /**
     * 新增推荐和今日特惠
     */
    @PreAuthorize("@ss.hasPermi('system:recommend:add')")
    @Log(title = "推荐和今日特惠", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ShopRecommend shopRecommend) {
        return toAjax(shopRecommendService.insertShopRecommend(shopRecommend));
    }

    /**
     * 修改推荐和今日特惠
     */
    @PreAuthorize("@ss.hasPermi('system:recommend:edit')")
    @Log(title = "推荐和今日特惠", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ShopRecommend shopRecommend) {
        return toAjax(shopRecommendService.updateShopRecommend(shopRecommend));
    }

    /**
     * 删除推荐和今日特惠
     */
    @PreAuthorize("@ss.hasPermi('system:recommend:remove')")
    @Log(title = "推荐和今日特惠", businessType = BusinessType.DELETE)
    @GetMapping("/remove")
    public AjaxResult remove(@RequestParam("goodsId") String goodsId, @RequestParam("shopId") String shopId, @RequestParam("type") String type) {
        return toAjax(shopRecommendService.deleteShopRecommend(goodsId, shopId, type));
    }


}
