package com.soss.system.mapper;

import com.soss.system.domain.CouponCategory;

import java.util.List;

/**
 * <p>
 * 优惠券类别 Mapper 接口
 * </p>
 *
 * @author caiyt
 * @since 2022-07-21
 */
public interface CouponCategoryMapper {
    /**
     * 新增优惠券类别
     *
     * @param couponCategory 优惠券类别
     * @return 结果
     */
    int insertCouponCategory(CouponCategory couponCategory);

    /**
     * 查询优惠券类别列表
     *
     * @param couponCategory 优惠券类别
     * @return 优惠券类别集合
     */
    List<CouponCategory> listCouponCategory(CouponCategory couponCategory);

    /**
     * 根据id查询优惠券类别
     *
     * @param id 优惠券类别ID
     * @return 优惠券类别
     */
    CouponCategory selectCouponCategoryById(Integer id);

    /**
     * 更新优惠券类别
     *
     * @param couponCategory 优惠券类别
     * @return 结果
     */
    int updateCouponCategory(CouponCategory couponCategory);
}
