package com.soss.system.mapper;

import com.soss.system.domain.OrderRefund;
import com.soss.system.domain.vo.OrderQuery;

import java.math.BigDecimal;
import java.util.List;

/**
 * 订单退款Mapper接口
 *
 * @author zxq
 * @date 2022-04-28
 */
public interface OrderRefundMapper {
    /**
     * 查询订单退款
     *
     * @param id 订单退款主键
     * @return 订单退款
     */
    public OrderRefund selectOrderRefundById(String id);

    /**
     * 查询订单退款列表
     *
     * @param orderRefund 订单退款
     * @return 订单退款集合
     */
    public List<OrderRefund> selectOrderRefundList(OrderRefund orderRefund);

    /**
     * 新增订单退款
     *
     * @param orderRefund 订单退款
     * @return 结果
     */
    public int insertOrderRefund(OrderRefund orderRefund);

    /**
     * 修改订单退款
     *
     * @param orderRefund 订单退款
     * @return 结果
     */
    public int updateOrderRefund(OrderRefund orderRefund);

    /**
     * 删除订单退款
     *
     * @param id 订单退款主键
     * @return 结果
     */
    public int deleteOrderRefundById(String id);

    /**
     * 批量删除订单退款
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteOrderRefundByIds(String[] ids);

    List<OrderRefund> selectList(OrderQuery orderQuery);

    /**
     * 获取订单已成功退款的总额
     */
    BigDecimal sumOrderRefundAmount(Long orderId);
}
