package com.soss.system.service;

import com.soss.system.domain.CouponUser;
import com.soss.system.domain.GoodsSku;
import com.soss.system.domain.Order;
import com.soss.system.domain.OrderDetail;
import com.soss.system.domain.vo.CouponUserVo;
import com.soss.system.domain.vo.CouponVo;

import java.util.List;

/**
 * <p>
 * 用户领取优惠券记录表 服务类
 * </p>
 *
 * @author caiyt
 * @since 2022-07-21
 */
public interface ICouponUserService {

    void giveUserCoupon(String custId, Integer couponId);

    int getCustAvailableCouponCnt(String custId);

    List<CouponVo> listCustAvailableCoupon(String custId, Integer couponUserId);

    List<CouponVo> listCustCoupons(String custId, Boolean effectiveFlag);

    List<CouponUserVo> selectCouponUserList(CouponUser couponUser);

    void resovleCouponFitable(List<CouponVo> couponVos, Order order);

    List<GoodsSku> orderDetailCheckAndAssign(Long shopId, List<OrderDetail> orderDetails);
}
