package com.soss.system.service;

import com.alibaba.fastjson.JSONObject;
import com.soss.system.domain.Goods;
import com.soss.system.domain.GoodsCategory;
import com.soss.system.domain.GoodsSku;
import com.soss.system.domain.Shop;

import java.util.List;
import java.util.Map;

/**
 * 店铺Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IShopService 
{
    /**
     * 查询店铺
     * 
     * @param id 店铺主键
     * @return 店铺
     */
    public Shop selectShopById(Long id);

    /**
     * 查询店铺列表
     * 
     * @param shop 店铺
     * @return 店铺集合
     */
    public List<Shop> selectShopList(Shop shop);

    void testFinish(Long shopId);

    void testStart(Long shopId);

    void open(Long shopId);

    /**
     * 新增店铺
     * 
     * @param shop 店铺
     * @return 结果
     */
    public long insertShop(Shop shop);

    /**
     * 修改店铺
     * 
     * @param shop 店铺
     * @return 结果
     */
    public int updateShop(Shop shop);

    /**
     * 批量删除店铺
     * 
     * @param ids 需要删除的店铺主键集合
     * @return 结果
     */
    public int deleteShopByIds(String[] ids);

    String addGoods(long shopId, String goodsIds);

    List<GoodsCategory>  getCategoryGoods(long shopId);

    List<GoodsSku> getSkuByGoodsId(long shopId, long goodsId);

    String turn(Long shopId, Long goodsId, String pointer);

    List<String> getShopCity();


    Map<String, Map<String, Map<String, List<Shop>>>> getShopAreaTree();

    String offGoods(JSONObject body);


    List<Goods> selectGoodsList(String goodsName, String category, Long shopId);
}
