package com.soss.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.soss.common.exception.ServiceException;
import com.soss.system.domain.Order;
import com.soss.system.domain.vo.ResultVo;
import com.soss.system.mapper.OrderDetailMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
@Slf4j
public class RobotServiceImpl {
    @Value("machine.url")
    private String url;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private OrderDetailMapper orderDetailMapper;

    public void createOrder(Order order){
        try{
            String interfaceName = "/v1/order";
            String postUrl = url+interfaceName;
            String orderInfo = JSONObject.toJSONString(order);
            log.info("请求创建订单接口：【{}】",orderInfo);
            ResponseEntity<String> stringResponseEntity = restTemplate.postForEntity(postUrl, orderInfo, String.class);
            log.info("请求创建订单接口返回结果为：【{}】",stringResponseEntity.getBody());
            ResultVo resultVo = JSONObject.parseObject(stringResponseEntity.getBody(), ResultVo.class);
            String code = resultVo.getCode();
            if("2001".equals(code)){
                throw  new ServiceException("库存不足");
            }else   if("3001".equals(code)){
                throw  new ServiceException("机器繁忙");
            }
        }catch (Exception e){
            log.error("请求发生异常：",e);
            throw  new ServiceException("服务器繁忙，请重试");
        }

    }
}
