package com.soss.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.soss.system.mapper.SpecRuleMapper;
import com.soss.system.domain.SpecRule;
import com.soss.system.service.ISpecRuleService;

/**
 * 规格选项Service业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class SpecRuleServiceImpl implements ISpecRuleService 
{
    @Autowired
    private SpecRuleMapper specRuleMapper;

    /**
     * 查询规格选项
     * 
     * @param id 规格选项主键
     * @return 规格选项
     */
    @Override
    public SpecRule selectSpecRuleById(String id)
    {
        return specRuleMapper.selectSpecRuleById(id);
    }

    /**
     * 查询规格选项列表
     * 
     * @param specRule 规格选项
     * @return 规格选项
     */
    @Override
    public List<SpecRule> selectSpecRuleList(SpecRule specRule)
    {
        return specRuleMapper.selectSpecRuleList(specRule);
    }

    /**
     * 新增规格选项
     * 
     * @param specRule 规格选项
     * @return 结果
     */
    @Override
    public int insertSpecRule(SpecRule specRule)
    {
        return specRuleMapper.insertSpecRule(specRule);
    }

    /**
     * 修改规格选项
     * 
     * @param specRule 规格选项
     * @return 结果
     */
    @Override
    public int updateSpecRule(SpecRule specRule)
    {
        return specRuleMapper.updateSpecRule(specRule);
    }

    /**
     * 批量删除规格选项
     * 
     * @param ids 需要删除的规格选项主键
     * @return 结果
     */
    @Override
    public int deleteSpecRuleByIds(String[] ids)
    {
        return specRuleMapper.deleteSpecRuleByIds(ids);
    }

    /**
     * 删除规格选项信息
     * 
     * @param id 规格选项主键
     * @return 结果
     */
    @Override
    public int deleteSpecRuleById(String id)
    {
        return specRuleMapper.deleteSpecRuleById(id);
    }
}
