package com.soss.system.utils;

import com.soss.common.utils.StringUtils;
import jodd.util.StringPool;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ArrayUtil {
    public static <T> void listAddArray(List<T> lst, T[] ts) {
        if (hasContents(ts)) {
            lst.addAll(Arrays.asList(ts));
        }
    }

    public static <T> boolean isAllAvailable(T[] ts) {
        if (ts == null || ts.length != 1) {
            return false;
        }
        T t = ts[0];
        if (t instanceof String) {
            return Objects.equals(t, "0");
        } else if (t instanceof Integer) {
            return Objects.equals(t, 0);
        } else if (t instanceof Long) {
            return Objects.equals(t, 0L);
        }
        return false;
    }

    public static <T> boolean hasContents(T[] ts) {
        return ts != null && ts.length > 0;
    }

    public static String[] transStrToCodeList(String codeStr) {
        return StringUtils.isEmpty(codeStr) ? null : codeStr.split(",");
    }

    public static Integer[] transStrToIntList(String idsStr) {
        if (StringUtils.isEmpty(idsStr)) {
            return null;
        }
        return Arrays.stream(idsStr.split(",")).map(Integer::parseInt).toArray(Integer[]::new);
    }

    public static Long[] transStrToLongList(String idsStr) {
        if (StringUtils.isEmpty(idsStr)) {
            return null;
        }
        return Arrays.stream(idsStr.split(",")).map(Long::parseLong).toArray(Long[]::new);
    }

    public static <T> boolean contains(T[] ts, T t) {
        if (ts == null || ts.length == 0) {
            return false;
        }
        for (T src : ts) {
            if (Objects.equals(src, t)) {
                return true;
            }
        }
        return false;
    }

    public static boolean containsSplit(Long[] arr, String target) {
        if (StringUtils.isEmpty(target)) {
            return false;
        }

        for (String tar : target.split(StringPool.COMMA)) {
            if (!StringUtils.isEmpty(tar) && contains(arr, Long.parseLong(tar))) {
                return true;
            }
        }
        return false;
    }

    public static <T> boolean isEmpty(T[] ts) {
        return ts == null || ts.length == 0;
    }

    public static boolean hasCommonElement(String[] arr1, String[] arr2) {
        if (arr1 == null || arr2 == null) {
            return false;
        }
        for (String target : arr1) {
            if (Objects.equals(target, "")) {
                continue;
            }
            for (String source : arr2) {
                if (Objects.equals(target, source)) {
                    return true;
                }
            }
        }

        return false;
    }
}
