package com.soss.web.controller.coffee;

import java.util.List;

import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.soss.common.annotation.Log;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.enums.BusinessType;
import com.soss.system.domain.Material;
import com.soss.system.service.IMaterialService;
import com.soss.common.core.page.TableDataInfo;

/**
 * 原料Controller
 * 
 * @author zxq
 * @date 2022-04-28
 */
@RestController
@RequestMapping("/system/material")
public class MaterialController extends BaseController
{
    @Autowired
    private IMaterialService materialService;

    /**
     * 查询原料列表
     */
    @PreAuthorize("@ss.hasPermi('system:material:list')")
    @GetMapping("/list")
    public TableDataInfo list(Material material)
    {
        startPage();
        List<Material> list = materialService.selectMaterialList(material);
        return getDataTable(list);
    }



    /**
     * 获取原料详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:material:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(materialService.selectMaterialById(id));
    }

    /**
     * 新增原料
     */
  //  @PreAuthorize("@ss.hasPermi('system:material:add')")
    @Log(title = "原料", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Material material)
    {
        return  AjaxResult.success(materialService.insertMaterial(material));
    }

    /**
     * 修改原料
     */
    @PreAuthorize("@ss.hasPermi('system:material:edit')")
    @Log(title = "原料", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Material material)
    {
        return materialService.updateMaterial(material);
    }

    /**
     * 删除原料
     */
    @PreAuthorize("@ss.hasPermi('system:material:remove')")
    @Log(title = "原料", businessType = BusinessType.DELETE)
    @RequestMapping("/remove")
    public AjaxResult remove(@RequestParam  String id)
    {
        return  materialService.deleteMaterialById(id);
    }


}
