package com.soss.web.controller.coffee;

import com.soss.common.annotation.Log;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.core.domain.model.LoginUser;
import com.soss.common.core.page.TableDataInfo;
import com.soss.common.enums.BusinessType;
import com.soss.common.enums.RefundState;
import com.soss.common.exception.ServiceException;
import com.soss.common.utils.StringUtils;
import com.soss.framework.web.service.TokenService;
import com.soss.framework.web.service.WeixinServiceImpl;
import com.soss.system.domain.Order;
import com.soss.system.domain.OrderRefund;
import com.soss.system.domain.vo.OrderQuery;
import com.soss.system.service.IGoodsService;
import com.soss.system.service.IOrderRefundService;
import com.soss.system.service.impl.OrderServiceImpl;
import io.jsonwebtoken.lang.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Objects;

/**
 * 订单退款Controller
 *
 * @author zxq
 * @date 2022-04-28
 */
@RestController
@RequestMapping("/system/refund")
public class OrderRefundController extends BaseController {
    @Autowired
    private IOrderRefundService orderRefundService;
    @Autowired
    private WeixinServiceImpl weixinService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private IGoodsService goodsService;

    /**
     * 查询订单退款列表
     */
    @PreAuthorize("@ss.hasPermi('system:refund:list')")
    @GetMapping("/list")
    public TableDataInfo list(OrderQuery orderQuery) {
        startPage();
        List<OrderRefund> list = orderRefundService.selectOrderRefundList(orderQuery);
        return getDataTable(list);
    }

    /**
     * 查询订单退款列表
     */
    @GetMapping("/list/{orderId}")
    public AjaxResult listByOrderId(@PathVariable Long orderId) {
        OrderRefund or = new OrderRefund();
        or.setOrderId(orderId);
        List<OrderRefund> list = orderRefundService.selectOrderRefundList(or);
        return AjaxResult.success(list);
    }

    /**
     * 获取订单退款详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:refund:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id) {
        OrderRefund refund = orderRefundService.selectOrderRefundById(id);
        goodsService.resolverGoodsOfOrder(refund.getOrder());
        return AjaxResult.success(refund);
    }

    /**
     * 新增订单退款
     */
    @Log(title = "订单退款", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(HttpServletRequest request, @RequestBody OrderRefund orderRefund) {
        Assert.notNull(orderRefund.getRefundAmount(), "退款金额还未传递");
        LoginUser loginUser = tokenService.getLoginUser(request);
        if (loginUser == null) {
            throw new ServiceException("请先登录");
        }
        if (StringUtils.isEmpty(loginUser.getOpenId())) {
            Assert.notEmpty(orderRefund.getOrderDetailIds(), "退款订单明细ID还未传递");
        }
        orderRefund.setCreateUserName(loginUser.getUsername());
        AjaxResult ajaxResult = orderRefundService.insertOrderRefund(orderRefund);

        Object obejct = ajaxResult.get(AjaxResult.DATA_TAG);
        if (obejct instanceof OrderRefund) {
            OrderRefund orderRefund1 = (OrderRefund) obejct;
            if (RefundState.PENDING.getState().equals(orderRefund1.getState())) {
                int refundAmount = orderRefund1.getRefundAmount().movePointRight(2).intValue();
                if (refundAmount > 0) {
                    int totalFee = orderRefund1.getOrder().getPaidAmount().movePointRight(2).intValue();
                    boolean refundSuc;
                    try {
                        String refundResult = weixinService.refund(orderRefund1.getOrderNo(), orderRefund1.getRefundNo(), totalFee, refundAmount);
                        refundSuc = !Objects.equals("退款失败", refundResult);
                    } catch (Exception e) {
                        refundSuc = false;
                    }
                    orderRefund1.setState(refundSuc ? RefundState.REFUNDING.getState() : RefundState.FAILURE.getState());
                } else {
                    orderRefund1.setState(RefundState.SUCCESS.getState());
                }
                orderRefundService.updateOrderRefund(orderRefund1);
            }
        }

        return ajaxResult;
    }

    /**
     * 新增订单退款
     */
    @Log(title = "后台退款", businessType = BusinessType.INSERT)
    @PostMapping("/background")
    public AjaxResult background(@RequestBody OrderRefund orderRefund) {
        Assert.notNull(orderRefund.getRefundAmount(), "退款金额还未传递");
        orderRefund.setCreateUserName("BRAIN");
        AjaxResult ajaxResult = orderRefundService.insertOrderRefund(orderRefund);

        Object obejct = ajaxResult.get(AjaxResult.DATA_TAG);
        if (obejct instanceof OrderRefund) {
            OrderRefund orderRefund1 = (OrderRefund) obejct;
            if (RefundState.PENDING.getState().equals(orderRefund1.getState())) {
                int refundAmount = orderRefund1.getRefundAmount().movePointRight(2).intValue();
                if (refundAmount > 0) {
                    int totalFee = orderRefund1.getOrder().getPaidAmount().movePointRight(2).intValue();
                    boolean refundSuc;
                    try {
                        String refundResult = weixinService.refund(orderRefund1.getOrderNo(), orderRefund1.getRefundNo(), totalFee, refundAmount);
                        refundSuc = !Objects.equals("退款失败", refundResult);
                    } catch (Exception e) {
                        refundSuc = false;
                    }
                    orderRefund1.setState(refundSuc ? RefundState.REFUNDING.getState() : RefundState.FAILURE.getState());
                } else {
                    orderRefund1.setState(RefundState.SUCCESS.getState());
                }
                orderRefundService.updateOrderRefund(orderRefund1);
            }
        }

        return ajaxResult;
    }

    @PostMapping("/refund")
    public void refund() {
        Order order = orderService.selectOrderById(98L);
        int totalFee = order.getAmount().movePointRight(2).intValue();
        weixinService.refund(order.getOrderNo(), order.getOrderNo() + "1", totalFee, totalFee);

    }


//        public void refund(HttpServletRequest request,
//                     String openid,
//                     int activityid,
//                       int memberid) throws Exception {
//        //先将订单信息查出来  这里的订单就是上边说的支付订单，我的是通过openid和一个activityid查出来的，自己可根据业务逻辑修改。
//        QueryWrapper<Wxpaynotifyvo> wxPayNotifyVOQueryWrapper = new QueryWrapper<>();
//        wxPayNotifyVOQueryWrapper.eq("openid", openid);
//        wxPayNotifyVOQueryWrapper.eq("activityid", activityid);
//        Wxpaynotifyvo wxPayNotifyVO = this.wxPayService.getBaseMapper().selectOne(wxPayNotifyVOQueryWrapper);
//        //构建参数
//        Map<String, String> dataMap = new HashMap<>();
//        //小程序ID
//        dataMap.put("appid", WechatConstant.APPID);
//        //商户号
//        dataMap.put("mch_id", WechatConstant.MCH_ID);
//        //随机字符串
//        dataMap.put("nonce_str", UUID.randomUUID().toString().replaceAll("-", ""));
//        //微信订单号
//        dataMap.put("transaction_id", wxPayNotifyVO.getTransactionid());
//        //商户退款单号
//        Date now = new Date();
//        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");//可以方便地修改日期格式
//        String outRefundNo = "NO" + dateFormat.format(now);
//        dataMap.put("out_refund_no", outRefundNo);
//        //订单金额
//        dataMap.put("total_fee", wxPayNotifyVO.getTotalfee());
//
//        //退款金额
//        dataMap.put("refund_fee", wxPayNotifyVO.getTotalfee());
//        //商户证书密钥，生成签名
//        String sign = WXPayUtil.generateSignature(dataMap, WechatConstant.KEY);
//        dataMap.put("sign", sign);
//        //这个是将报名表里的数据删除
//        int i = applymanService.deleteApplyman(openid, activityid, memberid);
//        //这个不是
//        this.wxPayService.refound(dataMap);
//        Res res = new Res();
//        res.setCode(0);
//        res.setMsg("退款成功！");
//        return res;
//    }


}
