package com.soss.common.enums;

public enum CouponState {
    ONLINE(1, "生效中"),
    OFFLINE(2, "未生效"),
    EXPIRED(3, "已失效"),
    DELETE(4, "已删除");

    private Integer state;
    private String desc;

    CouponState(Integer state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public Integer getState() {
        return state;
    }

    public static String getDesc(Integer state) {
        for (CouponState categoryType : CouponState.values()) {
            if (categoryType.state.equals(state)) {
                return categoryType.desc;
            }
        }
        return null;
    }
}
