package com.soss.common.enums;

/**
 * 商品状态枚举类
 */
public enum GoodsState {
    NORMAL(1, "默认"),
    PAUSE(2, "暂停销售"),
    ONLINE(3, "上架"),
    OFFLINE(4, "下架"),
    DELETE(5, "已删除");

    private Integer state;
    private String desc;

    GoodsState(Integer state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public Integer getState() {
        return state;
    }

    public static String getDesc(Integer state) {
        for (GoodsState goodsState : GoodsState.values()) {
            if (goodsState.state.equals(state)) {
                return goodsState.desc;
            }
        }
        return null;
    }
}
