package com.soss.common.enums;

/**
 * 消息发送状态枚举类
 */
public enum MessageState {
    TO_BE_SEND(0, "待发送"),
    SENDING(1, "发送中"),
    SUCCESS(2, "成功"),
    FAILURE(3, "失败");

    private Integer state;
    private String desc;

    MessageState(Integer state, String desc) {
        this.state = state;
        this.desc = desc;
    }

    public Integer getState() {
        return state;
    }

    public static String getDesc(Integer state) {
        for (MessageState messageState : MessageState.values()) {
            if (messageState.state.equals(state)) {
                return messageState.desc;
            }
        }
        return null;
    }
}
