package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.core.domain.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 优惠券规则
 * </p>
 *
 * @author caiyt
 * @since 2022-07-21
 */
@Data
public class CouponRule extends BaseEntity {
    /**
     * 主键
     */
    private Integer id;

    /**
     * 优惠劵规则名
     */
    private String name;

    /**
     * 优惠劵规则描述
     */
    private String desc;

    /**
     * 可用省份列表 可存code列表
     */
    private String province;

    /**
     * 可用城市列表
     */
    private String city;

    /**
     * 可用区域列表
     */
    private String area;

    /**
     * 可用店铺ID列表
     */
    private String shopIds;

    /**
     * 可用商品类别列表
     */
    private String categoryIds;

    /**
     * 可用商品id列表
     */
    private String goodsIds;

    /**
     * 可领取时间时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime receivableTime;

    /**
     * 使用绝对开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime useStartTime;

    /**
     * 使用绝对截止时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime useEndTime;

    /**
     * 领取后相对有效天数
     */
    private Integer relativeTime;

    /**
     * 价格扣减（当券类型为抵扣时单位为'元'，当券类型为折扣时，单位为'折'）
     */
    private BigDecimal priceDiscount;

    /**
     * 价格门槛
     */
    private BigDecimal priceLimit;

    /**
     * 订单限制 0 整单 1 单杯
     */
    private Boolean orderLimit;

    /**
     * 周几限制 1,2,3
     */
    private String weekLimit;

    /**
     * 用户领取次数限制0无限制
     */
    private Integer userLimit;

    /**
     * 用户领取天数限制0无限制
     */
    private Integer daysLimit;

    /**
     * 是否发送短信0不1发
     */
    private Boolean sendMsg;

    /**
     * 短信模板ID
     */
    private Integer msgId;

    /**
     * 规则状态0正常1停用
     */
    private Integer state;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updatedAt;


}
