package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 订单对象 order
 *
 * @author zxq
 * @date 2022-04-28
 */
@Data
public class Order implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 订单号
     */
    @Excel(name = "订单号")
    private String orderNo;

    /**
     * 订单顺序号
     */
    @Excel(name = "订单顺序号")
    private String orderNum;

    /**
     * 用户ID
     */
    @Excel(name = "用户ID")
    private String userId;

    /**
     * 冗余
     */
    @Excel(name = "冗余")
    private String userName;

    /**
     * 冗余
     */
    @Excel(name = "冗余")
    private String userPhone;

    /**
     * 支付时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "支付时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date payTime;

    /**
     * 完成时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "完成时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date finishTime;

    /**
     * 订单金额
     */
    @Excel(name = "订单金额")
    private BigDecimal amount;

    /**
     * 优惠券id
     */
    private Integer couponId;

    /**
     * 优惠金额
     */
    @Excel(name = "优惠金额")
    private BigDecimal couponAmount;

    /**
     * 实付金额
     */
    @Excel(name = "实付金额")
    private BigDecimal paidAmount;

    /**
     * 商品数量
     */
    @Excel(name = "商品数量")
    private String goodsNum;

    /**
     * 取餐码
     */
    @Excel(name = "取餐码")
    private String pickCode;

    /**
     * 店铺ID
     */
    @Excel(name = "店铺ID")
    private Long shopId;

    /**
     * 机器ID
     */
    @Excel(name = "机器ID")
    private String machineId;

    /**
     * 点单屏序号
     */
    @Excel(name = "点单屏序号")
    private Integer source;

    @Excel(name = "订单状态 0 未支付取消 1 未支付 2 已支付 3 待制作 4 支付制作中 5 制作完成未取 6 取餐中 7 取餐完成 8 支付后制作前取消 9  制作中取消 10 制作完成取消 11 已退款  12 部分退款 50 其他人工干预状态")
    private String state;

    /**
     * 下单成功通知
     */
    @ApiModelProperty("用户授权发送消息1：0-未授权 1-授权")
    private Boolean sendMsgFlag1;

    /**
     * 订单状态变更通知
     */
    @ApiModelProperty("用户授权发送消息2：0-未授权 1-授权")
    private Boolean sendMsgFlag2;

    /**
     * 取餐提醒
     */
    @ApiModelProperty("用户授权发送消息3：0-未授权 1-授权")
    private Boolean sendMsgFlag3;

    /**
     * 支付参数
     */
    private String payParam;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    /**
     * 下单时用户所在地的经度
     */
    @ApiModelProperty("下单时用户所在地的经度")
    private BigDecimal lng;

    /**
     * 下单时用户所在地的纬度
     */
    @ApiModelProperty("下单时用户所在地的纬度")
    private BigDecimal lat;

    private Shop shop;

    private List<OrderDetail> orderDetails;

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("orderNo", getOrderNo())
                .append("orderNum", getOrderNum())
                .append("userId", getUserId())
                .append("userName", getUserName())
                .append("userPhone", getUserPhone())
                .append("payTime", getPayTime())
                .append("finishTime", getFinishTime())
                .append("amount", getAmount())
                .append("goodsNum", getGoodsNum())
                .append("pickCode", getPickCode())
                .append("shopId", getShopId())
            .append("machineId", getMachineId())
            .append("source", getSource())
            .append("state", getState())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .toString();
    }
}
