package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.annotation.Excel;
import com.soss.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 小程序信息发送对象 wechat_message
 *
 * @author zxq
 * @date 2022-04-28
 */
@Data
public class WechatMessage extends BaseEntity {
    /**
     * 主键
     */
    private String id;

    /**
     * 用户ID
     */
    @Excel(name = "用户ID")
    private String userId;

    /**
     * 推送ID
     */
    @Excel(name = "推送ID")
    private String msgId;

    /**
     * 消息内容
     */
    @Excel(name = "消息内容")
    private String message;

    @ApiModelProperty("跳转目标ID")
    private Long targetId;

    /**
     * 目标跳转url
     */
    @Excel(name = "目标跳转url")
    private String targetUrl;

    /**
     * 消息发送状态 0 待发送 1 发送中 2 成功 3 失败
     */
    @ApiModelProperty("消息发送状态 0 待发送 1 发送中 2 成功 3 失败")
    private Integer state;

    private String title;

    /**
     * 消息类型 1 取餐消息 2 积分消息 等
     */
    @ApiModelProperty("消息类型 1 取餐消息 2 积分消息 3-优惠券消息 等")
    private Integer type;

    /**
     * 消息阅读状态 1 未读 2 已读
     */
    @Excel(name = "消息阅读状态 1 未读 2 已读")
    private String isRead;

    /**
     * 0 未删除 1 已删除
     */
    @Excel(name = "0 未删除 1 已删除")
    private String isDeleted;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("userId", getUserId())
                .append("msgId", getMsgId())
                .append("message", getMessage())
                .append("targetUrl", getTargetUrl())
                .append("state", getState())
                .append("type", getType())
                .append("isRead", getIsRead())
                .append("isDeleted", getIsDeleted())
                .append("createdAt", getCreatedAt())
                .append("updatedAt", getUpdatedAt())
                .toString();
    }
}
