package com.soss.system.domain.vo;

import com.soss.system.domain.po.CouponPo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Map;

@ApiModel
@Data
public class CouponVo extends CouponPo {

    @ApiModelProperty("优惠券id")
    private Integer couponId;

    @ApiModelProperty("优惠券规则id")
    private Integer ruleId;

    @ApiModelProperty("优惠劵规则名称")
    private String ruleName;

    @ApiModelProperty("优惠劵规则描述")
    private String ruleDesc;

    @ApiModelProperty("优惠券编码")
    private String serialNo;

    @ApiModelProperty("优惠券类型 1 抵扣 2 折扣 3 免单")
    private Integer type;

    @ApiModelProperty("优惠券类型描述")
    private String typeDesc;

    @ApiModelProperty("优惠券通用描述")
    private String categoryDesc;

    @ApiModelProperty("优惠券状态")
    private Integer state;

    @ApiModelProperty("优惠券状态描述")
    private String stateDesc;

    @ApiModelProperty("优惠券类别名")
    private String categoryName;

    @ApiModelProperty("可用商品范围描述")
    private String goodLimitDesc;

    @ApiModelProperty("可用区域/门店描述")
    private String areaLimitDesc;

    @ApiModelProperty("每周几可用描述")
    private String weekLimitDesc;

    @ApiModelProperty(value = "不可用原因，小程序端展示优惠券列表用")
    private String notFitableDesc;

    @ApiModelProperty("优惠金额")
    private BigDecimal couponAmount;

    @ApiModelProperty("每个商品优惠金额字典：skuId为key，减免金额为value")
    private Map<Long, BigDecimal> couponAmountMap;

    @ApiModelProperty(value = "可用商品类别列表字符串，全品类传 [0]", hidden = true)
    private String categoryIdStr;

    @ApiModelProperty(value = "可用商品id列表字符串", hidden = true)
    private String goodsIdStr;

    @ApiModelProperty(value = "可用省份列表字符串，全国通用传 [0]", hidden = true)
    private String provinceStr;

    @ApiModelProperty(value = "可用城市列表字符串", hidden = true)
    private String cityStr;

    @ApiModelProperty(value = "可用区域列表字符串", hidden = true)
    private String areaStr;

    @ApiModelProperty(value = "可用店铺ID列表字符串", hidden = true)
    private String shopIdStr;

    @ApiModelProperty(value = "每周几可用字符串", hidden = true)
    private String weekLimitStr;
}
