package com.soss.system.mapper;

import com.soss.system.domain.GoodsCategory;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商品分类Mapper接口
 *
 * @author zxq
 * @date 2022-04-28
 */
public interface GoodsCategoryMapper {
    /**
     * 查询商品分类
     *
     * @param id 商品分类主键
     * @return 商品分类
     */
    public GoodsCategory selectGoodsCategoryById(String id);

    /**
     * 查询商品分类集合，供翻译使用
     *
     * @param ids 商品分类主键集合
     * @return 商品分类
     */
    List<GoodsCategory> selectGoodsCategoryByIds(@Param("ids") List<Long> ids);

    /**
     * 查询商品分类列表
     *
     * @param goodsCategory 商品分类
     * @return 商品分类集合
     */
    public List<GoodsCategory> selectGoodsCategoryList(GoodsCategory goodsCategory);

    /**
     * 新增商品分类
     * 
     * @param goodsCategory 商品分类
     * @return 结果
     */
    public int insertGoodsCategory(GoodsCategory goodsCategory);

    /**
     * 修改商品分类
     * 
     * @param goodsCategory 商品分类
     * @return 结果
     */
    public int updateGoodsCategory(GoodsCategory goodsCategory);

    /**
     * 删除商品分类
     * 
     * @param id 商品分类主键
     * @return 结果
     */
    public int deleteGoodsCategoryById(String id);

    /**
     * 批量删除商品分类
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteGoodsCategoryByIds(String[] ids);

    List<String> selectCategoryIdByShopId(long shopId);

    GoodsCategory selectGoodsCategoryPointer(String id, String pointer);
}
