package com.soss.system.mapper;

import java.util.List;
import com.soss.system.domain.Material;

/**
 * 原料Mapper接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface MaterialMapper 
{
    /**
     * 查询原料
     * 
     * @param id 原料主键
     * @return 原料
     */
    public Material selectMaterialById(String id);

    /**
     * 查询原料列表
     * 
     * @param material 原料
     * @return 原料集合
     */
    public List<Material> selectMaterialList(Material material);

    /**
     * 新增原料
     * 
     * @param material 原料
     * @return 结果
     */
    public Long insertMaterial(Material material);

    /**
     * 修改原料
     * 
     * @param material 原料
     * @return 结果
     */
    public int updateMaterial(Material material);

    /**
     * 删除原料
     * 
     * @param id 原料主键
     * @return 结果
     */
    public int deleteMaterialById(String id);

    /**
     * 批量删除原料
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMaterialByIds(String[] ids);
}
