package com.soss.system.push.impl;

import com.alibaba.fastjson.JSONObject;
import com.soss.system.push.PushService;
import com.soss.system.service.impl.MachineApiServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

/**
 * 推送服务
 * 封装业务功能相关
 */
@Service
@Slf4j
public class PushServiceImpl implements PushService {
    @Autowired
    @Lazy
    private MachineApiServiceImpl machineApiService;

    /**
     * 推送全部, 不支持附加信息
     *
     * @return
     */
    @Override
    public boolean pushAll(String message) {
        return sendPush(null, null, message);
    }

    /**
     * 推送android 指定id
     *
     * @return
     */
    @Override
    public boolean push(String machineCode, Integer screenNo, String message) {
        return sendPush(machineCode, screenNo, message);
    }

    @Override
    public boolean push(String machineCode, String message) {
        push(machineCode, 1, message);
        push(machineCode, 2, message);
        return true;
    }

    @Override
    public boolean sendPush(String machineCode, Integer screenNo, String message) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("machineCode", machineCode);
        requestBody.put("screenNo", screenNo);
        requestBody.put("message", message);
        machineApiService.sendRequest(requestBody.toJSONString(), "/v1/push");
        return true;
    }
}
