package com.soss.system.service;

import java.util.List;

import com.soss.common.core.domain.AjaxResult;
import com.soss.system.domain.Material;

/**
 * 原料Service接口
 * 
 * @author zxq
 * @date 2022-04-28
 */
public interface IMaterialService 
{
    /**
     * 查询原料
     * 
     * @param id 原料主键
     * @return 原料
     */
    public Material selectMaterialById(String id);

    /**
     * 查询原料列表
     * 
     * @param material 原料
     * @return 原料集合
     */
    public List<Material> selectMaterialList(Material material);

    /**
     * 新增原料
     * 
     * @param material 原料
     * @return 结果
     */
    public Long insertMaterial(Material material);

    /**
     * 修改原料
     * 
     * @param material 原料
     * @return 结果
     */
    public AjaxResult updateMaterial(Material material);

    /**
     * 批量删除原料
     * 
     * @param ids 需要删除的原料主键集合
     * @return 结果
     */
    public int deleteMaterialByIds(String[] ids);

    /**
     * 删除原料信息
     * 
     * @param id 原料主键
     * @param boo
     * @return 结果
     */
    public AjaxResult deleteMaterialById(String id);

    /**
     * 判断原料是否在使用
     * @param ids
     * @return
     */
    boolean selectMaterialIsUserd(String[] ids);
}
