package com.soss.system.service.impl;

import com.soss.system.domain.GoodsSku;
import com.soss.system.mapper.GoodsSkuMapper;
import com.soss.system.service.IGoodsSkuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 由规格选项组合生成商品skuService业务层处理
 * 
 * @author zxq
 * @date 2022-04-28
 */
@Service
public class GoodsSkuServiceImpl implements IGoodsSkuService 
{
    @Autowired
    private GoodsSkuMapper goodsSkuMapper;

    /**
     * 查询由规格选项组合生成商品sku
     * 
     * @param id 由规格选项组合生成商品sku主键
     * @return 由规格选项组合生成商品sku
     */
    @Override
    public GoodsSku selectGoodsSkuById(Long id)
    {
        return goodsSkuMapper.selectGoodsSkuById(id);
    }

    /**
     * 查询由规格选项组合生成商品sku列表
     * 
     * @param goodsSku 由规格选项组合生成商品sku
     * @return 由规格选项组合生成商品sku
     */
    @Override
    public List<GoodsSku> selectGoodsSkuList(GoodsSku goodsSku)
    {
        return goodsSkuMapper.selectGoodsSkuList(goodsSku);
    }

    /**
     * 新增由规格选项组合生成商品sku
     * 
     * @param goodsSku 由规格选项组合生成商品sku
     * @return 结果
     */
    @Override
    public int insertGoodsSku(GoodsSku goodsSku)
    {
        return goodsSkuMapper.insertGoodsSku(goodsSku);
    }

    /**
     * 修改由规格选项组合生成商品sku
     * 
     * @param goodsSku 由规格选项组合生成商品sku
     * @return 结果
     */
    @Override
    public int updateGoodsSku(GoodsSku goodsSku)
    {
        return goodsSkuMapper.updateGoodsSku(goodsSku);
    }

    /**
     * 批量删除由规格选项组合生成商品sku
     * 
     * @param ids 需要删除的由规格选项组合生成商品sku主键
     * @return 结果
     */
    @Override
    public int deleteGoodsSkuByIds(String[] ids)
    {
        return goodsSkuMapper.deleteGoodsSkuByIds(ids);
    }

    /**
     * 删除由规格选项组合生成商品sku信息
     * 
     * @param id 由规格选项组合生成商品sku主键
     * @return 结果
     */
    @Override
    public int deleteGoodsSkuById(String id)
    {
        return goodsSkuMapper.deleteGoodsSkuById(id);
    }
}
