package com.soss.system.service.impl;

import com.soss.common.utils.StringUtils;
import com.soss.system.constants.OrderStatusConstant;
import com.soss.system.domain.Order;
import com.soss.system.domain.OrderOperationLog;
import com.soss.system.domain.OrderRefund;
import com.soss.system.domain.vo.ResultVo;
import com.soss.system.mapper.OrderOperationLogMapper;
import com.soss.system.service.IOrderOperationLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 【请填写功能名称】Service业务层处理
 * 
 * @author zxq
 * @date 2022-05-17
 */
@Service
public class OrderOperationLogServiceImpl implements IOrderOperationLogService 
{
    @Autowired
    private OrderOperationLogMapper orderOperationLogMapper;

    /**
     * 查询【请填写功能名称】
     * 
     * @param id 【请填写功能名称】主键
     * @return 【请填写功能名称】
     */
    @Override
    public OrderOperationLog selectOrderOperationLogById(String id)
    {
        return orderOperationLogMapper.selectOrderOperationLogById(id);
    }

    /**
     * 查询【请填写功能名称】列表
     * 
     * @param orderOperationLog 【请填写功能名称】
     * @return 【请填写功能名称】
     */
    @Override
    public List<OrderOperationLog> selectOrderOperationLogList(OrderOperationLog orderOperationLog)
    {
        return orderOperationLogMapper.selectOrderOperationLogList(orderOperationLog);
    }

    /**
     * 新增【请填写功能名称】
     * 
     * @param  【请填写功能名称】
     * @return 结果
     */
    @Override
    public int insertOrderOperationLog(Order order)
    {
        OrderOperationLog operationLog = new OrderOperationLog();
        operationLog.setOrderId(order.getId());
        operationLog.setCreateAt(new Date());
        String state = order.getState();

        switch (state){
            case OrderStatusConstant.Unpaid:
                operationLog.setStatus("待付款");
                operationLog.setOperation("创建订单");
                operationLog.setOperationUser(order.getUserName());
                operationLog.setContent("创建了订单");
                break;
            case OrderStatusConstant.UnpaidCancel:
                operationLog.setStatus("已取消");
                operationLog.setOperation("取消订单");
                operationLog.setOperationUser(order.getUserName());
                operationLog.setContent("用户取消订单");
                break;
            case OrderStatusConstant.Paid:
                operationLog.setStatus("已付款");
                operationLog.setOperation("付款");
                operationLog.setOperationUser(order.getUserName());
                operationLog.setContent("付款成功");
                break;
            case OrderStatusConstant.production:
                operationLog.setStatus("制作中");
                operationLog.setOperation("同步信息");
                operationLog.setOperationUser("接口");
                operationLog.setContent("机器推送制作中");
                break;
            case OrderStatusConstant.productionCompleted:
                operationLog.setStatus("制作完成");
                operationLog.setOperation("同步信息");
                operationLog.setOperationUser("接口");
                operationLog.setContent("机器推送制作完成");
                break;
            case OrderStatusConstant.Taking:
                operationLog.setStatus("取餐中");
                operationLog.setOperation("同步信息");
                operationLog.setOperationUser("接口");
                operationLog.setContent("机器推送取餐中");
                break;
            case OrderStatusConstant.completed:
                operationLog.setStatus("已完成");
                operationLog.setOperation("同步信息");
                operationLog.setOperationUser("接口");
                operationLog.setContent("机器推送已完成");
                break;
            case OrderStatusConstant.refunding:
                operationLog.setStatus("退款");
                operationLog.setOperation("退款中");
                operationLog.setOperationUser("接口");
                operationLog.setContent("正在退款中");
                break;
            case OrderStatusConstant.PartialRefund:
                operationLog.setStatus("退款");
                operationLog.setOperation("微信退款");
                operationLog.setOperationUser("接口");
                operationLog.setContent("正在退款中");
                break;
        }
        return orderOperationLogMapper.insertOrderOperationLog(operationLog);
    }

    /**
     * 修改【请填写功能名称】
     * 
     * @param orderOperationLog 【请填写功能名称】
     * @return 结果
     */
    @Override
    public int updateOrderOperationLog(OrderOperationLog orderOperationLog)
    {
        return orderOperationLogMapper.updateOrderOperationLog(orderOperationLog);
    }

    /**
     * 批量删除【请填写功能名称】
     * 
     * @param ids 需要删除的【请填写功能名称】主键
     * @return 结果
     */
    @Override
    public int deleteOrderOperationLogByIds(String[] ids)
    {
        return orderOperationLogMapper.deleteOrderOperationLogByIds(ids);
    }

    /**
     * 删除【请填写功能名称】信息
     * 
     * @param id 【请填写功能名称】主键
     * @return 结果
     */
    @Override
    public int deleteOrderOperationLogById(String id)
    {
        return orderOperationLogMapper.deleteOrderOperationLogById(id);
    }

    public void insertOrderOperationLog(OrderRefund orderRefund) {
        Order order = orderRefund.getOrder();
        OrderOperationLog operationLog = new OrderOperationLog();
        operationLog.setOrderId(order.getId());
        operationLog.setCreateAt(new Date());
        if(StringUtils.isEmpty(orderRefund.getDesc())){
            operationLog.setStatus("已退款");
            operationLog.setOperation("退款");
            operationLog.setOperationUser("系统");
            operationLog.setContent("用户完成退款");
        }else{
            operationLog.setStatus("已退款");
            operationLog.setOperation("售后");
            operationLog.setOperationUser(orderRefund.getCreateUserName());
            operationLog.setContent(orderRefund.getDesc());
        }
        orderOperationLogMapper.insertOrderOperationLog(operationLog);


    }

    public void insertOrderOperationLog(Order order, ResultVo resultVo) {
        OrderOperationLog operationLog = new OrderOperationLog();
        operationLog.setOrderId(order.getId());
        operationLog.setCreateAt(new Date());
        String state = order.getState();
        operationLog.setOperation("同步消息");
        operationLog.setOperationUser("接口");
        String result = "0".equals(resultVo.getCode()) ? "成功" : "失败";
        switch (state){
            case OrderStatusConstant.UnpaidCancel:
            case OrderStatusConstant.PaidCancel:
                operationLog.setStatus("已取消");
                operationLog.setContent("取消订单信息同步【" + result + "】");
                break;
            case OrderStatusConstant.Paid:
                operationLog.setStatus("已付款");
                operationLog.setContent("付款信息同步【" + result + "】");
                break;
            default:
                return;
        }
         orderOperationLogMapper.insertOrderOperationLog(operationLog);
    }
}
