package com.soss.framework.web.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.WxPayRefundResult;
import com.github.binarywang.wxpay.bean.result.WxPayUnifiedOrderResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.wxpay.sdk.WXPayUtil;
import com.soss.common.core.domain.entity.SysUser;
import com.soss.common.core.domain.model.LoginUser;
import com.soss.common.enums.RefundState;
import com.soss.common.enums.ShopState;
import com.soss.common.exception.ServiceException;
import com.soss.common.utils.QRCodeUtil;
import com.soss.common.utils.StringUtils;
import com.soss.common.utils.ip.IpUtils;
import com.soss.common.utils.sign.Base64;
import com.soss.common.utils.sign.Md5Utils;
import com.soss.system.constants.OrderStatusConstant;
import com.soss.system.domain.*;
import com.soss.system.mapper.CustomerMapper;
import com.soss.system.mapper.OrderDetailMapper;
import com.soss.system.mapper.OrderRefundMapper;
import com.soss.system.mapper.ShopMapper;
import com.soss.system.service.impl.AppServiceImpl;
import com.soss.system.service.impl.OrderOperationLogServiceImpl;
import com.soss.system.service.impl.OrderServiceImpl;
import com.soss.system.utils.DistanceUtil;
import com.soss.system.weixin.entity.OrderInfo;
import com.soss.system.weixin.entity.QueryReturnInfo;
import com.soss.system.weixin.util.RandomStringGenerator;
import com.soss.system.weixin.util.Signature;
import com.thoughtworks.xstream.XStream;
import io.jsonwebtoken.lang.Assert;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.spec.AlgorithmParameterSpec;
import java.text.ParseException;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

@Service
public class WeixinServiceImpl {

    private static final Logger log = LoggerFactory.getLogger(WeixinServiceImpl.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private OrderDetailMapper orderDetailMapper;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private OrderOperationLogServiceImpl orderOperationLogService;
    @Autowired
    private OrderRefundMapper orderRefundMapper;
    @Autowired
    private ShopMapper shopMapper;
    @Autowired
    private OssFileServiceImpl ossFileService;
    @Autowired
    private AppServiceImpl appService;


    private final ReentrantLock lock = new ReentrantLock();


    @Value("${weixin.appid}")
    private String appid;

    @Value("${weixin.secret}")
    private String secret;
    @Value("${weixin.mchid}")
    private String mchId;
    @Value("${weixin.key}")
    private String key;
    @Value("${weixin.notify-url}")
    private String notifyUrl;
    @Value("${weixin.trade-type}")
    private String tradeType;
    @Value("${weixin.url}")
    private String url;
    @Value("${weixin.query-url}")
    private String queryUrl;
    @Value("${weixin.refund-url}")
    private String refundUrl;
    @Value("${weixin.qr-size}")
    private String qrSize;
    private String areaData;

    public String getSessionKeyOrOpenId(String code) {
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid={0}&secret={1}&js_code={2}&grant_type=authorization_code";
        String replaceUrl = url.replace("{0}", appid).replace("{1}", secret).replace("{2}", code);
        String res = restTemplate.getForObject(replaceUrl, String.class);
        log.info("微信返回的信息为：【{}】", res);
        return res;
    }

    public String getAccessToken() {
        String accessTokenKey = "ACCESS_TOKEN";
        String accessToken = stringRedisTemplate.opsForValue().get(accessTokenKey);
        if (StringUtils.isNotEmpty(accessToken)) {
            return accessToken;
        }

        synchronized (this) {
            if (StringUtils.isNotEmpty(accessToken)) {
                return accessToken;
            }

            String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={0}&secret={1}";
            String replaceUrl = url.replace("{0}", appid).replace("{1}", secret);
            JSONObject res = restTemplate.getForObject(replaceUrl, JSONObject.class);
            log.info("微信返回的信息为：【{}】", res);
            if (res == null) {
                return null;
            }

            accessToken = res.getString("access_token");
            Integer expiresIn = res.getInteger("expires_in");
            stringRedisTemplate.opsForValue().set(accessTokenKey, accessToken);
            stringRedisTemplate.expire(accessTokenKey, expiresIn - 100, TimeUnit.SECONDS);
        }
        return accessToken;
    }

    @PostConstruct
    public void initAreaData() {
        try {
            ClassPathResource resource = new ClassPathResource("province.json");
            byte[] bdata = FileCopyUtils.copyToByteArray(resource.getInputStream());
            areaData = new String(bdata, StandardCharsets.UTF_8);
        } catch (Exception e) {
            log.error("", e);
        }
    }

    public String login(String code) {
        String sessionKeyOrOpenId = getSessionKeyOrOpenId(code);
        return sessionKeyOrOpenId;
    }

    private LoginUser transLoginUser(Customer customer) {
        SysUser user = new SysUser();
        user.setUserName(customer.getUserName());
        LoginUser loginUser = new LoginUser(user, null);
        loginUser.setLoginTime(System.currentTimeMillis());
        loginUser.setOpenId(customer.getId());
        user.setPhonenumber(customer.getPhone());
        return loginUser;

    }

    public String wxDecrypt(String encryptedData, String json, String vi) throws Exception {
        // 开始解密
        //：{"session_key":"G59Evf\/Em54X6WsFsrpA1g==","openid":"o2ttv5L2yufc4-VoSPhTyUnToY60"}
        String sessionKey = json;
        byte[] encData = Base64.decode(encryptedData);
        byte[] iv = Base64.decode(vi);
        byte[] key = Base64.decode(sessionKey);
        AlgorithmParameterSpec ivSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        cipher.init(Cipher.DECRYPT_MODE, keySpec, ivSpec);
        return new String(cipher.doFinal(encData), "UTF-8");
    }

    public Map orderQuery() {
        Map<String, Object> map = new HashMap<>();

        try {
            OrderInfo order = new OrderInfo();
            order.setAppid(appid);
            order.setMch_id(mchId);
            order.setNonce_str(RandomStringGenerator.getRandomStringByLength(32));
            order.setOut_trade_no("wuyye9w8akwbq1nc60o4affwwqnxh9dn");
            //order.setSign_type("MD5");
            //生成签名
            String sign = Signature.getSign(order, key);
            order.setSign(sign);
            String result = restTemplate.postForObject(queryUrl, order, String.class);
            System.out.println(result);
            XStream xStream = new XStream();
            xStream.alias("xml", QueryReturnInfo.class);

            QueryReturnInfo returnInfo = (QueryReturnInfo) xStream.fromXML(result);
            map.put("status", 500);
            map.put("msg", "统一下单失败!");
            map.put("data", returnInfo);
            return map;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Autowired
    private WxPayService wxPayService;

    public Map<String, String> weChatPay(HttpServletRequest r, String body, String orderNo, String openId, int money) {
        /**
         * 处理内部业务，校验订单等
         */
        final WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = WxPayUnifiedOrderRequest.newBuilder()
                //调起支付的人的 openId
                .openid(openId)
                //订单编号
                .outTradeNo(orderNo)
                //订单金额
                .totalFee(money)
                //商品描述
                .body("订单信息")
                //获取本地IP
                .spbillCreateIp(InetAddress.getLoopbackAddress().getHostAddress())
                //回调的 URL 地址
                .notifyUrl("http://我们的域名/api/client/pay/weChatPayNotify")
                .build();
        WxPayUnifiedOrderResult wxPayUnifiedOrderResult = null;
        try {
            wxPayUnifiedOrderResult = wxPayService.unifiedOrder(wxPayUnifiedOrderRequest);
        } catch (WxPayException e) {
            e.printStackTrace();
            throw new RuntimeException("微信支付调起失败！");
        }
        return null;
    }

    public String refund(String orderNo, String refundNo, Integer totalFee, Integer refundFee) {
        //申请退款
        WxPayRefundRequest refundInfo = WxPayRefundRequest.newBuilder()
                //订单号
                .outTradeNo(orderNo)
                //退款订单号
                .outRefundNo(refundNo)
                //金额
                .totalFee(totalFee)
                //退款金额
                .refundFee(refundFee)
                //todo 回调地址
                .notifyUrl(refundUrl)
                .build();
        WxPayRefundResult wxPayRefundResult;
        try {
            wxPayRefundResult = wxPayService.refund(refundInfo);
            //判断退款信息是否正确
            if ("SUCCESS".equals(wxPayRefundResult.getReturnCode())) {
                /**
                 * 系统内部业务逻辑
                 */
                return "正在退款中。。";
            }
        } catch (WxPayException e) {
            log.error("微信退款接口错误信息= {}", e);
            throw new ServiceException("微信退款失败");
        }

        return "退款失败";
    }


    public Map<String, String> pay(HttpServletRequest r, String body, String orderNo, String openId, int money) {
        try {
            HttpClientUtils client = new HttpClientUtils(url);
            //组装接口参数
            Map<String, String> params = new HashMap<>();
            params.put("appid", appid);//关联的公众号的appid
            params.put("mch_id", mchId);//商户号
            params.put("nonce_str", WXPayUtil.generateNonceStr());//生成随机字符串
            params.put("body", body);
            params.put("out_trade_no", orderNo);
            params.put("openid", openId);
            //注意，这里必须使用字符串类型的参数（总金额：分）

            params.put("total_fee", String.valueOf(money));

            params.put("spbill_create_ip", IpUtils.getIpAddr(r));
            params.put("notify_url", notifyUrl);
            params.put("trade_type", "JSAPI");

            //将参数转换成xml字符串格式：生成带有签名的xml格式字符串
            String xmlParams = WXPayUtil.generateSignedXml(params, key);
            log.info("\n xmlParams：\n" + xmlParams);

            client.setXmlParam(xmlParams);//将参数放入请求对象的方法体
            client.setHttps(true);//使用https形式发送
            client.post();//发送请求
            String resultXml = client.getContent();//得到响应结果
            log.info("\n resultXml：\n" + resultXml);
            //将xml响应结果转成map对象
            Map<String, String> resultMap = WXPayUtil.xmlToMap(resultXml);

            //错误处理
            if ("FAIL".equals(resultMap.get("return_code")) || "FAIL".equals(resultMap.get("result_code"))) {
                log.error("微信支付统一下单错误 ===> {} ", resultXml);
                throw new RuntimeException("微信支付统一下单错误");
            }
            long time = System.currentTimeMillis() / 1000;
            Map<String, String> signInfo = new HashMap<>();
            signInfo.put("appId", appid);
            signInfo.put("timeStamp", String.valueOf(time));
            signInfo.put("nonceStr", WXPayUtil.generateNonceStr());
            signInfo.put("repay_id", "prepay_id=" + resultMap.get("prepay_id"));
            signInfo.put("signType", "MD5");
            //生成签名


            Map<String, String> payInfo = new HashMap<>();
            payInfo.put("appId", appid);
            payInfo.put("timeStamp", signInfo.get("timeStamp"));
            payInfo.put("nonceStr", signInfo.get("nonceStr"));
            payInfo.put("package", signInfo.get("repay_id"));
            payInfo.put("signType", "MD5");
            String sign1 = WXPayUtil.generateSignature(payInfo, key);
            payInfo.put("paySign", sign1);
            // 此处可以写唤起支付前的业务逻辑
            // 业务逻辑结束 回传给小程序端唤起支付
            return payInfo;
        } catch (Exception e) {
            log.error("微信支付发生异常", e);
            throw new ServiceException("微信支付异常");
        }
    }


    @Transactional
    public synchronized String wxNotify(HttpServletRequest request) throws Exception {
        Map<String, String> returnMap = new HashMap<>();//应答对象

        //处理通知参数
        String body = this.readData(request);
        log.info("wx notify receive origin: \n{}", body);

        //验签
        if (!WXPayUtil.isSignatureValid(body, key)) {
            log.error("通知验签失败");
            //失败应答
            returnMap.put("return_code", "FAIL");
            returnMap.put("return_msg", "验签失败");
            String returnXml = WXPayUtil.mapToXml(returnMap);
            return returnXml;
        }

        //解析xml数据
        Map<String, String> notifyMap = WXPayUtil.xmlToMap(body);
        log.info("wx notify receive decode: \n{}", JSONObject.toJSONString(notifyMap));
        //判断通信和业务是否成功
        if (!"SUCCESS".equals(notifyMap.get("return_code")) || !"SUCCESS".equals(notifyMap.get("result_code"))) {
            log.error("失败");
            //失败应答
            returnMap.put("return_code", "FAIL");
            returnMap.put("return_msg", "失败");
            String returnXml = WXPayUtil.mapToXml(returnMap);
            return returnXml;
        }

        //获取商户订单号
        String orderNo = notifyMap.get("out_trade_no");
        //并校验返回的订单金额是否与商户侧的订单金额一致
//        if (order1 != null && order1.get() != Long.parseLong(notifyMap.get("total_fee"))) {
//            log.error("金额校验失败");
//            //失败应答
//            returnMap.put("return_code", "FAIL");
//            returnMap.put("return_msg", "金额校验失败");
//            String returnXml = WXPayUtil.mapToXml(returnMap);
//            return returnXml;
//        }

        //处理订单
//        if (lock.tryLock()) {
        Order order = new Order();
        order.setOrderNo(orderNo);
        List<Order> orders = orderService.selectOrderList(order);
        if (orders.isEmpty()) {
            returnMap.put("return_code", "FAIL");
            returnMap.put("return_msg", "没有该订单");
            return WXPayUtil.mapToXml(returnMap);
        }
        order = orders.get(0);
//        try {
        //处理重复的通知
        //接口调用的幂等性：无论接口被调用多少次，产生的结果是一致的。
        String orderStatus = order.getState();
        log.info("order current status: {}", orderStatus);
        if (OrderStatusConstant.Unpaid.equals(orderStatus)) {
            //更新订单状态
            order.setPayTime(new Date());
            order.setState(OrderStatusConstant.Paid);
            order.setPickCode(generatePickCode(order));
            orderService.updateOrder(order);
        }
        /*} finally {
            //要主动释放锁
            lock.unlock();
        }*/
//        }
        returnMap.put("return_code", "SUCCESS");
        returnMap.put("return_msg", "OK");
        String returnXml = WXPayUtil.mapToXml(returnMap);
        log.info("支付成功，已应答");
        return returnXml;
    }

    public String wxNotifyTest(String orderNo) throws Exception {
//        Map<String, String> returnMap = new HashMap<>();//应答对象

        //处理通知参数
//        String body = this.readData(request);

//        //验签
//        if(!WXPayUtil.isSignatureValid(body, key)) {
//            log.error("通知验签失败");
//            //失败应答
//            returnMap.put("return_code", "FAIL");
//            returnMap.put("return_msg", "验签失败");
//            String returnXml = WXPayUtil.mapToXml(returnMap);
//            return returnXml;
//        }

        //解析xml数据
//        Map<String, String> notifyMap = WXPayUtil.xmlToMap(body);
//        //判断通信和业务是否成功
//        if(!"SUCCESS".equals(notifyMap.get("return_code")) || !"SUCCESS".equals(notifyMap.get("result_code"))) {
//            log.error("失败");
//            //失败应答
//            returnMap.put("return_code", "FAIL");
//            returnMap.put("return_msg", "失败");
//            String returnXml = WXPayUtil.mapToXml(returnMap);
//            return returnXml;
//        }

        //获取商户订单号
//        String orderNo = notifyMap.get("out_trade_no");
        Order order = new Order();
        order.setOrderNo(orderNo);
        List<Order> orders = orderService.selectOrderList(order);
        if (orders.isEmpty()) {
            return "没有该订单";

        }
        order = orders.get(0);
        //并校验返回的订单金额是否与商户侧的订单金额一致
//        if (order1 != null && order1.get() != Long.parseLong(notifyMap.get("total_fee"))) {
//            log.error("金额校验失败");
//            //失败应答
//            returnMap.put("return_code", "FAIL");
//            returnMap.put("return_msg", "金额校验失败");
//            String returnXml = WXPayUtil.mapToXml(returnMap);
//            return returnXml;
//        }

        //处理订单
        if (lock.tryLock()) {
            try {
                //处理重复的通知
                //接口调用的幂等性：无论接口被调用多少次，产生的结果是一致的。
                String orderStatus = order.getState();
                if (OrderStatusConstant.Unpaid.equals(orderStatus)) {
                    //更新订单状态
                    order.setPayTime(new Date());
                    order.setState(OrderStatusConstant.Paid);
                    order.setPickCode(generatePickCode(order));
                    orderService.updateOrder(order);
                }
            } finally {
                //要主动释放锁
                lock.unlock();
            }
        }
        return "支付成功，已应答";
    }

    public String generatePickCode(Order order) {
        String uid = UUID.randomUUID().toString();
        stringRedisTemplate.opsForValue().set(uid, String.valueOf(order.getId()));
        stringRedisTemplate.expire(uid, 1, TimeUnit.DAYS);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orderId", order.getId());
        jsonObject.put("userId", order.getUserId());
        jsonObject.put("secret", uid);

        String[] qrSizeArr = qrSize.split("\\*");
        int width = Integer.parseInt(qrSizeArr[0]);
        int height = Integer.parseInt(qrSizeArr[1]);

        String content = jsonObject.toJSONString() + "###";
        String qrCode = QRCodeUtil.getQRCodeSvg(content, width, height, false);
        String qrCodeKey = Md5Utils.hash(qrCode);
        stringRedisTemplate.opsForValue().set(qrCodeKey, qrCode);
        stringRedisTemplate.expire(qrCodeKey, 1, TimeUnit.DAYS);

        return qrCodeKey;
    }

    /**
     * 将通知参数转化为字符串
     *
     * @param request
     * @return
     */
    public String readData(HttpServletRequest request) {
        BufferedReader br = null;
        try {
            StringBuilder result = new StringBuilder();
            br = request.getReader();
            for (String line; (line = br.readLine()) != null; ) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append(line);
            }
            return result.toString();
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String refundNotify(String xmlData) {
        WxPayRefundNotifyResult wxPayRefundNotifyResult;
        try {
            wxPayRefundNotifyResult = wxPayService.parseRefundNotifyResult(xmlData);
        } catch (WxPayException e) {
            log.error("退款失败", e);
            return WxPayNotifyResponse.fail("退款失败");
        }
        //判断你返回状态信息是否正确
        if ("SUCCESS".equals(wxPayRefundNotifyResult.getReturnCode())) {
            WxPayRefundNotifyResult.ReqInfo reqInfo = wxPayRefundNotifyResult.getReqInfo();
            String outRefundNo = reqInfo.getOutRefundNo();
            OrderRefund orderRefund = new OrderRefund();
            orderRefund.setRefundNo(outRefundNo);
            List<OrderRefund> orderRefunds = orderRefundMapper.selectOrderRefundList(orderRefund);
            if (orderRefunds.isEmpty()) {
                log.error("找不到该退款订单：【{}】", outRefundNo);
                return WxPayNotifyResponse.fail("退款失败");
            }
            OrderRefund orderRefund1 = orderRefunds.get(0);
            Order order = orderService.selectById(orderRefund1.getOrderId());
            if (RefundState.REFUNDING.getState().equals(orderRefund1.getState())) {
                orderRefund1.setState(RefundState.SUCCESS.getState());
                orderRefundMapper.updateOrderRefund(orderRefund1);
                OrderOperationLog orderOperationLog = new OrderOperationLog();
                orderOperationLog.setOrderId(orderRefund1.getOrderId());
                order.setState(OrderStatusConstant.refund);
                BigDecimal refundedAmount = orderRefundMapper.sumOrderRefundAmount(order.getId());
                if (refundedAmount == null || refundedAmount.compareTo(order.getPaidAmount()) < 0) {
                    order.setState(OrderStatusConstant.PartialRefund);
                }
                orderRefund1.setOrder(order);
                orderService.updateOrder(order);
                orderDetailMapper.updateRefundState(orderRefund1.getId(), new Date());
                orderOperationLogService.insertOrderOperationLog(orderRefund1);
                return WxPayNotifyResponse.success("退款成功！");
            }


            //判断退款状态
//            if (REFUND_SUCCESS.equals(reqInfo.getRefundStatus())) {
//                //内部订单号
//                String outTradeNo = reqInfo.getOutTradeNo();
//                /**
//                 * 一、可能会重复回调，需要做防重判断
//                 * 二、处理我们系统内部业务，做修改订单状态，释放资源等！
//                 */
//                return WxPayNotifyResponse.success("退款成功！");
//            }
        } else {
            WxPayRefundNotifyResult.ReqInfo reqInfo = wxPayRefundNotifyResult.getReqInfo();
            String outRefundNo = reqInfo.getOutRefundNo();
            OrderRefund orderRefund = new OrderRefund();
            orderRefund.setRefundNo(outRefundNo);
            List<OrderRefund> orderRefunds = orderRefundMapper.selectOrderRefundList(orderRefund);
            if (orderRefunds.isEmpty()) {
                log.error("找不到该退款订单：【{}】", outRefundNo);
                return WxPayNotifyResponse.fail("退款失败");
            }
            OrderRefund orderRefund1 = orderRefunds.get(0);
            Order order = orderService.selectById(orderRefund1.getOrderId());
            if (RefundState.REFUNDING.getState().equals(orderRefund1.getState())) {
                orderRefund1.setState(RefundState.FAILURE.getState());
                orderRefundMapper.updateOrderRefund(orderRefund1);
                OrderOperationLog orderOperationLog = new OrderOperationLog();
                orderOperationLog.setOrderId(orderRefund1.getOrderId());
                order.setState(OrderStatusConstant.refundFailed);

                orderRefund1.setOrder(order);
                orderService.updateOrder(order);
                orderOperationLogService.insertOrderOperationLog(orderRefund1);
                return WxPayNotifyResponse.success("");
            }
        }
        return WxPayNotifyResponse.fail("回调有误!");
    }

    public List<JSONObject> getArea(String lng, String lat, Boolean testFlag) throws ParseException {
        String provinceString = "[value ='%s'][0].label";
        String cityString = "[value='%s'][0].children[value='%s'][0].label";
        String zoneString = "[value='%s'][0].children[value='%s'][0].children[value='%s'][0].label";
        Shop shop = new Shop();
        if (BooleanUtils.isTrue(testFlag)) {
            shop.setStates(Arrays.asList(ShopState.TESTING.getState(), ShopState.OPEN.getState(), ShopState.CLOSE.getState()));
        } else {
            shop.setStates(Arrays.asList(ShopState.OPEN.getState(), ShopState.CLOSE.getState()));
        }
        List<Shop> shops = shopMapper.selectShopList(shop);
        List<JSONObject> proviceList = new ArrayList<>();
        if (CollectionUtils.isEmpty(shops)) {
            return proviceList;
        }
        List<String> proString = new ArrayList<>();
        for (Shop shop1 : shops) {
            if (StringUtils.isNotEmpty(lng) && StringUtils.isNotEmpty(lat)) {
                double realDistance = DistanceUtil.getRealDistance(Double.parseDouble(lng), Double.parseDouble(lat), Double.parseDouble(shop1.getLng()), Double.parseDouble(shop1.getLat()));
                shop1.setRealDistance(realDistance);
                shop1.setDistance(DistanceUtil.getDistanceDesc(realDistance));
                appService.perfectOrderState(shop1, lng, lat);
            } else {
                shop1.setDistance("-1");
                shop1.setOrderState(1);
            }
            if (BooleanUtils.isTrue(testFlag) && ShopState.TESTING.getState().equals(shop1.getState())) {
                shop1.setState(ShopState.OPEN.getState());
                shop1.setOrderState(1);
                shop1.setStateDesc("");
            }
            String province = shop1.getProvince();
            if (proString.contains(province)) {
                for (JSONObject provinceObject : proviceList) {
                    if (province.equals(provinceObject.getString("value"))) {
                        JSONArray cityChild = provinceObject.getJSONArray("children");
                        boolean cityboo = true;
                        for (int i = 0; i < cityChild.size(); i++) {
                            JSONObject city = cityChild.getJSONObject(i);
                            if (shop1.getCity().equals(city.getString("value"))) {
                                cityboo = false;
                                JSONArray zooeObject = city.getJSONArray("children");
                                boolean zoneBoo = true;
                                for (int j = 0; j < zooeObject.size(); j++) {
                                    JSONObject zooe = zooeObject.getJSONObject(j);
                                    if (shop1.getZone().equals(zooe.getString("value"))) {
                                        zoneBoo = false;
                                        JSONArray shopInfos = zooe.getJSONArray("shops");
                                        shopInfos.add(shop1);
                                        ArrayList<Shop> shopList = (ArrayList<Shop>) shopInfos.toJavaList(Shop.class);
                                        List<Shop> collect = shopList.stream().sorted((a, b) -> a.getDistance().compareTo(b.getDistance())).collect(Collectors.toList());
                                        zooe.put("shops", collect);
                                    }
                                }
                                if (zoneBoo) {
                                    JSONObject zone = new JSONObject();
                                    zone.put("value", shop1.getZone());
                                    zone.put("name", JSONPath.read(areaData, String.format(zoneString, province, shop1.getCity(), shop1.getZone())));
                                    zooeObject.add(zone);
                                    List<Shop> shopList = new ArrayList<>();
                                    shopList.add(shop1);
                                    zone.put("shops", shopList);
                                }
                            }
                        }
                        if (cityboo) {
                            JSONObject city = new JSONObject();
                            city.put("value", shop1.getCity());
                            city.put("name", JSONPath.read(areaData, String.format(cityString, province, shop1.getCity())));
                            cityChild.add(city);
                            JSONObject zone = new JSONObject();
                            zone.put("value", shop1.getZone());
                            zone.put("name", JSONPath.read(areaData, String.format(zoneString, province, shop1.getCity(), shop1.getZone())));
                            List<Shop> shopList = new ArrayList<>();
                            shopList.add(shop1);
                            zone.put("shops", shopList);
                            List<JSONObject> zones = new ArrayList<>();
                            zones.add(zone);
                            city.put("children", zones);
                        }
                    }
                }
            } else {
                proString.add(province);
                JSONObject provice = new JSONObject();
                provice.put("value", province);
                String format = String.format(provinceString, province);
                provice.put("name", JSONPath.read(areaData, format));
                proviceList.add(provice);
                JSONObject city = new JSONObject();
                city.put("value", shop1.getCity());
                city.put("name", JSONPath.read(areaData, String.format(cityString, province, shop1.getCity())));
                List<JSONObject> citys = new ArrayList<>();
                citys.add(city);
                provice.put("children", citys);
                JSONObject zone = new JSONObject();
                zone.put("value", shop1.getZone());
                zone.put("name", JSONPath.read(areaData, String.format(zoneString, province, shop1.getCity(), shop1.getZone())));
                List<Shop> shopList = new ArrayList<>();
                shopList.add(shop1);
                zone.put("shops", shopList);
                List<JSONObject> zones = new ArrayList<>();
                zones.add(zone);
                city.put("children", zones);
            }
        }
        return proviceList;
    }

    public String createToken4Test(String custId) {
        Customer customer = customerMapper.selectCustomerById(custId);
        Assert.notNull(customer, "未查询到匹配的用户信息[" + custId + "]");
        LoginUser loginUser = transLoginUser(customer);
        return tokenService.createToken(loginUser);
    }

    public String refresh(String phoneNumber) {
        Customer customer = new Customer();
        customer.setPhone(phoneNumber);
        List<Customer> customers = customerMapper.selectCustomerList(customer);
        if (customers != null && !customers.isEmpty()) {
            Customer customer1 = customers.get(0);
            log.info("当前登录的用户为：【{}】", customer1.getUserName());
            return tokenService.createToken(transLoginUser(customer1));

        }
        throw new ServiceException("该用户没有注册，请先注册");
    }

    public String getPhone(String code, String iv, String encryptedData) {
        try {
            String sessionKeyOrOpenId = getSessionKeyOrOpenId(code);
            String infoString = this.wxDecrypt(encryptedData, sessionKeyOrOpenId, iv);
            JSONObject info = JSONObject.parseObject(infoString);
            return info.getString("phoneNumber");
        } catch (Exception e) {
            log.error("获取手机号异常", e);
            throw new ServiceException("获取手机号异常");
        }


    }

    @Transactional
    public Map<String, String> decrypt(String encryptedData, String iv, String source, String openId, String faceInfoId, String sessionKey) {
        try {

            String cutomerId = openId;
            String encData = this.wxDecrypt(encryptedData, sessionKey, iv);
            log.info("openId:{}, 当前用户的信息为:【{}】", openId, encData);
            Customer customer = customerMapper.selectCustomerById(cutomerId);
            JSONObject encDataInf = JSONObject.parseObject(encData);
            if (customer == null) {
                customer = new Customer();
                customer.setId(cutomerId);
                customer.setAvatarUrl(encDataInf.getString("avatarUrl"));
                customer.setUserName("小呼噜" + encDataInf.getString("phoneNumber").substring(encDataInf.getString("phoneNumber").length() - 4));
                customer.setPhone(encDataInf.getString("phoneNumber"));
                customer.setCreateTime(new Date());
                if (StringUtils.isNotEmpty(source)) {
                    customer.setSoucre(source);
                }
                customerMapper.insertCustomer(customer);
            }

            if (StringUtils.isNotEmpty(faceInfoId)) {
                customerMapper.insertCustFaceId(openId, faceInfoId);
            }

            String token = tokenService.createToken(transLoginUser(customer));
            Map map = new HashMap();
            map.put("token", token);
            map.put("phoneNumber", encDataInf.getString("phoneNumber"));
            map.put("customerName", customer.getUserName());
            if (customer.getTestFlag() != null && customer.getTestFlag()) {
                map.put("openId", customer.getId());
            }
            log.info("token:{}, phoneNumber:{}, customerName:{}", token, encDataInf.getString("phoneNumber"), customer.getUserName());
            return map;
        } catch (Exception e) {
            log.error("微信登录发生异常", e);
            throw new ServiceException("微信登录异常，请重新登录");
        }
    }
}
