package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * <p>
 * 优惠券
 * </p>
 *
 * @author caiyt
 * @since 2022-07-21
 */
@Data
@NoArgsConstructor
public class Coupon extends BaseEntity {
    /**
     * 主键
     */
    private Integer id;

    /**
     * 优惠劵名
     */
    private String name;

    /**
     * 优惠券编码
     */
    private String serialNo;

    /**
     * 优惠券类别ID
     */
    private Integer categoryId;

    /**
     * 优惠券类别名
     */
    private String categoryName;

    /**
     * 优惠券规则id
     */
    private Integer ruleId;

    /**
     * 优惠券类型 1 抵扣 2 折扣 3 免单
     */
    private Integer type;

    /**
     * 状态 0 默认 1 上线 2 下线
     */
    private Integer state;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updatedAt;

    public Coupon(Integer id, Integer state) {
        this.id = id;
        this.state = state;
    }
}
