package com.soss.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.soss.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单详情对象 order_detail
 *
 * @author zxq
 * @date 2022-04-28
 */
@Data
public class OrderDetail {

    /**
     * 主键
     */
    private Long id;

    /**
     * 订单ID
     */
    @Excel(name = "订单ID")
    private long orderId;

    /**
     * 商品ID
     */
    @Excel(name = "商品ID")
    private Long goodsId;

    /**
     * 商品名称
     */
    @Excel(name = "商品名称")
    private String goodsName;

    /**
     * 机器ID
     */
    @Excel(name = "机器ID")
    private String machineId;

    /**
     * 数量
     */
    @Excel(name = "数量")
    private Integer num;

    /**
     * 单价
     */
    private BigDecimal unitPrice;

    /**
     * 原价总额
     */
    private BigDecimal oriAmount;

    /**
     * 应付金额
     */
    @Excel(name = "应付金额")
    private BigDecimal amountShould;

    /**
     * 优惠券优惠金额
     */
    @Excel(name = "优惠券优惠金额")
    private BigDecimal couponAmount;

    /**
     * 实付金额
     */
    @Excel(name = "实付金额")
    private BigDecimal realAmount;

    /**
     * 原优惠价
     */
    @Excel(name = "原优惠价")
    private BigDecimal origDiscount;

    /**
     * 规格选项详情
     */
    @Excel(name = "规格选项详情")
    private String specRuleDetail;

    /**
     * 规格选项id集合
     */
    @Excel(name = "规格选项id集合")
    private String specRuleIds;

    /**
     * sku ID
     */
    @Excel(name = "sku ID")
    private Long skuId;

    /**
     * 商品分类
     */
    @Excel(name = "商品分类")
    private String goodsCategory;

    private Goods goods;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd ")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    @ApiModelProperty("退款记录ID")
    private Long refundId;

    @ApiModelProperty("退款时间")
    private Date refundTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "更新时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("orderId", getOrderId())
                .append("goodsId", getGoodsId())
                .append("goodsName", getGoodsName())
                .append("machineId", getMachineId())
                .append("num", getNum())
                .append("oriPrice", getOriAmount())
                .append("amountShould", getAmountShould())
                .append("couponAmount", getCouponAmount())
                .append("realAmount", getRealAmount())
                .append("specRuleDetail", getSpecRuleDetail())
                .append("specRuleIds", getSpecRuleIds())
                .append("skuId", getSkuId())
                .append("goodsCategory", getGoodsCategory())
                .append("createdAt", getCreatedAt())
                .append("updatedAt", getUpdatedAt())
                .toString();
    }
}
