package com.soss.system.mapper;

import com.soss.system.domain.Order;
import com.soss.system.domain.vo.OrderQuery;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 订单Mapper接口
 *
 * @author zxq
 * @date 2022-04-28
 */
public interface OrderMapper {
    /**
     * 查询订单
     *
     * @param id 订单主键
     * @return 订单
     */
    public Order selectOrderById(Long id);

    /**
     * 查询订单列表
     * 
     * @param order 订单
     * @return 订单集合
     */
    public List<Order> selectOrderList(Order order);

    /**
     * 新增订单
     * 
     * @param order 订单
     * @return 结果
     */
    public int insertOrder(Order order);

    /**
     * 修改订单
     * 
     * @param order 订单
     * @return 结果
     */
    public int updateOrder(Order order);

    /**
     * 删除订单
     * 
     * @param id 订单主键
     * @return 结果
     */
    public int deleteOrderById(Long id);

    /**
     * 批量删除订单
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteOrderByIds(String[] ids);

    int selectSalesVolume(@Param("shopId") Long shopId,@Param("goodsId") Long goodsId);

    BigDecimal selectSalesAmount(@Param("shopId") long id);

    List<Order> selectByUserId(String userId);

    List<Order> selectOrderByQuery(OrderQuery order);

    List<Order> selectOrder(@Param("status") List<String> status,@Param("machineId") String machineCode);

    List<Order> selectOrderByShopId(@Param("status") List<String> status,@Param("shopId") Long shopId);

    Order selectHomeByUserId(@Param("userId") String openId, @Param("status") List<String> status, @Param("shopId") String shopId);

    void updateTimeOut(@Param("status") String productionCompleted, @Param("timeout") String timeout);

    List<Order> selectOrderByUserId(@Param("userId") String openId, @Param("status") List<String> status);

    void updateCancel(@Param("status") String unpaid, @Param("timeout") int i);

    List<Order> selectOrderByTime(@Param("status") String unpaid, @Param("timeout") int i);

    List<Order> selectBeforeOrder(@Param("status") List<String> status, @Param("orderId") Long orderId);

    /**
     * 查询用户订单简单统计数据
     *
     * @param custId
     * @return 返回用户下单数，下单金额
     */
    Map<String, Object> getCustOrderSimpleStat(@Param("custId") String custId);

    void updateCustName(@Param("userName") String userName, @Param("userId") String userId);
}
