package com.soss.system.schedule;

import com.soss.system.mapper.CouponMapper;
import com.soss.system.mapper.CouponUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CouponSchedule {
    @Autowired
    private CouponMapper couponMapper;
    @Autowired
    private CouponUserMapper couponUserMapper;

    @Scheduled(cron = "0/1 * * * * ?")
    private void expireCoupon() {
        couponMapper.expireCoupon();
    }

    @Scheduled(cron = "0/1 * * * * ?")
    private void expireCouponUser() {
        couponUserMapper.expireCouponUser();
    }
}
