package com.soss.system.service;

import com.soss.system.domain.ShopGoods;
import com.soss.system.domain.ShopGoodsSku;

import java.util.List;

/**
 * 店铺和商品关联Service接口
 *
 * @author zxq
 * @date 2022-04-28
 */
public interface IShopGoodsService {
    /**
     * 查询店铺和商品关联
     *
     * @param id 店铺和商品关联主键
     * @return 店铺和商品关联
     */
    public ShopGoods selectShopGoodsById(String id);

    /**
     * 查询店铺和商品关联列表
     *
     * @param shopGoods 店铺和商品关联
     * @return 店铺和商品关联集合
     */
    public List<ShopGoods> selectShopGoodsList(ShopGoods shopGoods);

    /**
     * 新增店铺和商品关联
     *
     * @param shopGoods 店铺和商品关联
     * @return 结果
     */
    public int insertShopGoods(ShopGoods shopGoods);

    /**
     * 修改店铺和商品关联
     *
     * @param shopGoods 店铺和商品关联
     * @return 结果
     */
    public int updateShopGoods(ShopGoods shopGoods);

    /**
     * 批量删除店铺和商品关联
     *
     * @param ids 需要删除的店铺和商品关联主键集合
     * @return 结果
     */
    public int deleteShopGoodsByIds(String[] ids);

    /**
     * 删除店铺和商品关联信息
     *
     * @param id 店铺和商品关联主键
     * @return 结果
     */
    public int deleteShopGoodsById(String id);

    List<ShopGoodsSku> selectSkuByShopGoods(Long shopId, Long goodsId);
    Boolean updateShopGoodsSkuState(Long shopId, Long goodsId, List<Long> shopGoodsSkuId, Integer state);
}
