package com.soss.web.controller.coupon;


import com.soss.common.annotation.Log;
import com.soss.common.core.controller.BaseController;
import com.soss.common.core.domain.AjaxResult;
import com.soss.common.core.page.TableDataInfo;
import com.soss.common.enums.BusinessType;
import com.soss.common.enums.CouponUserState;
import com.soss.common.enums.CouponUserType;
import com.soss.common.enums.MessageType;
import com.soss.system.domain.CouponUser;
import com.soss.system.domain.vo.CouponUserVo;
import com.soss.system.service.ICouponUserService;
import com.soss.system.service.IWechatMessageService;
import io.jsonwebtoken.lang.Assert;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 用户领取优惠券记录表 前端控制器
 * </p>
 *
 * @author caiyt
 * @since 2022-07-21
 */
@RestController
@RequestMapping("/coupon-user")
@Api(tags = "用户领取优惠券记录服务类")
public class CouponUserController extends BaseController {
    @Autowired
    private ICouponUserService couponUserService;
    @Autowired
    private IWechatMessageService wechatMessageService;

    /**
     * 赠送优惠券
     */
    @PreAuthorize("@ss.hasPermi('coupon:user:give')")
    @Log(title = "赠送优惠券", businessType = BusinessType.INSERT)
    @PostMapping("give")
    @ApiOperation("赠送优惠券")
    public AjaxResult giveUserCoupon(@RequestBody CouponUser couponUser) {
        Assert.notNull(couponUser.getCustId(), "用户ID未传递");
        Assert.notNull(couponUser.getCouponId(), "优惠券ID未传递");
        couponUserService.giveUserCoupon(couponUser.getCustId(), couponUser.getCouponId());
        wechatMessageService.insertWechatMessage(couponUser.getCustId(), 0L, MessageType.COUPON.getType(), "HOOLOO券到账通知,收到新的HOOLOO券啦，快来领取吧");
        return AjaxResult.success();
    }

    /**
     * 查询用户领取优惠券列表
     */
    @PreAuthorize("@ss.hasPermi('coupon:user:list')")
    @PostMapping("list")
    @ApiOperation("查询用户领取优惠券列表")
    public TableDataInfo selectCouponUserList(@RequestBody CouponUser couponUser) {
        startPage();
        List<CouponUserVo> couponUserVos = couponUserService.selectCouponUserList(couponUser);
        couponUserVos.forEach(couponUserVo -> {
            couponUserVo.setTypeDesc(CouponUserType.getDesc(couponUserVo.getType()));
            couponUserVo.setStateDesc(CouponUserState.getDesc(couponUserVo.getState()));
        });
        return getDataTable(couponUserVos);
    }
}
